
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")

# Objective function
m.setObjective(1.66 * x0**2 + 2.23 * x1**2 + 5.28 * x1, GRB.MINIMIZE)

# Constraints
m.addConstr(20*x0 + 1*x1 >= 32, name="immune_support_lower_bound")
m.addConstr(20*x0 + 1*x1 <= 54, name="immune_support_upper_bound")
m.addConstr(13*x0 + 5*x1 >= 11, name="cardiovascular_support_lower_bound")
m.addConstr(13*x0 + 5*x1 <= 43, name="cardiovascular_support_upper_bound")
m.addConstr(5*x0**2 - 4*x1**2 >= 0, name="vitamin_ratio_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin A: {x0.x}")
    print(f"Milligrams of Vitamin B5: {x1.x}")
else:
    print("No optimal solution found.")
