
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Vitamin_Optimization")

# Define variables
milligrams_vitamin_A = model.addVar(name="milligrams_vitamin_A", vtype=GRB.INTEGER)
milligrams_vitamin_B5 = model.addVar(name="milligrams_vitamin_B5")

# Objective function
model.setObjective(1.66 * milligrams_vitamin_A**2 + 2.23 * milligrams_vitamin_B5**2 + 5.28 * milligrams_vitamin_B5, GRB.MINIMIZE)

# Constraints
model.addConstr(20 * milligrams_vitamin_A + 1 * milligrams_vitamin_B5 >= 32, name="immune_support_min")
model.addConstr(13 * milligrams_vitamin_A + 5 * milligrams_vitamin_B5 >= 11, name="cardiovascular_support_min")
model.addConstr(20 * milligrams_vitamin_A + 1 * milligrams_vitamin_B5 <= 54, name="immune_support_max")
model.addConstr(13 * milligrams_vitamin_A + 5 * milligrams_vitamin_B5 <= 43, name="cardiovascular_support_max")
model.addConstr(5 * milligrams_vitamin_A**2 - 4 * milligrams_vitamin_B5**2 >= 0, name="quadratic_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Vitamin A: {milligrams_vitamin_A.varValue}")
    print(f"Milligrams of Vitamin B5: {milligrams_vitamin_B5.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible.")
