
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
laura = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
peggy = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peggy")
bill = model.addVar(lb=0, vtype=GRB.INTEGER, name="Bill")

# Set objective function
model.setObjective(9*laura*laura + 2*laura*peggy + 3*laura*bill + 9*peggy*peggy + 8*peggy*bill + 9*bill*bill + 3*laura + 2*peggy + 9*bill, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*laura + 3*peggy + 2*bill <= 143, "c1")
model.addConstr(7*laura + 6*peggy + 14*bill <= 178, "c2")
model.addConstr(7*laura + 14*bill >= 20, "c3")
model.addConstr(7*laura + 6*peggy + 14*bill >= 30, "c4")
model.addConstr(3*peggy + 2*bill <= 92, "c5")
model.addConstr(6*laura + 3*peggy <= 100, "c6")
model.addConstr(6*laura + 3*peggy + 2*bill <= 100, "c7")
model.addConstr(6*peggy + 14*bill <= 121, "c8")
model.addConstr(7*laura + 6*peggy + 14*bill <= 76, "c9")
model.addConstr(7*laura + 6*peggy + 14*bill <= 76, "c10")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Laura: {laura.x}")
    print(f"Peggy: {peggy.x}")
    print(f"Bill: {bill.x}")
    print(f"Objective Value: {model.objVal}")

