
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - Hours worked by each person
L = m.addVar(lb=0, name="hours_worked_by_Laura")
P = m.addVar(lb=0, name="hours_worked_by_Peggy")
B = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Objective function
m.setObjective(9*L**2 + 2*L*P + 3*L*B + 9*P**2 + 8*P*B + 9*B**2 + 3*L + 2*P + 9*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*L + 14*B >= 20, name="min_likelihood_to_quit_Laura_Bill")
m.addConstr(7*L + 6*P + 14*B >= 30, name="total_likelihood_to_quit_all")
m.addConstr(3*P + 2*B <= 92, name="max_paperwork_Peggy_Bill")
m.addConstr(6*L + 3*P <= 100, name="max_paperwork_Laura_Peggy")
m.addConstr(6*L + 3*P + 2*B <= 100, name="max_total_paperwork_all")
m.addConstr(6*P + 14*B <= 121, name="max_likelihood_to_quit_Peggy_Bill")
m.addConstr(7*L + 6*P + 14*B <= 76, name="max_total_likelihood_to_quit_all")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Peggy: {P.x}")
    print(f"Hours worked by Bill: {B.x}")
else:
    print("No optimal solution found.")
