
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
laura_hours = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="laura_hours")
peggy_hours = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="peggy_hours")
bill_hours = m.addVar(lb=0, type=gurobi.GRB.INTEGER, name="bill_hours")

# Objective function
m.setObjective(9 * laura_hours ** 2 + 2 * laura_hours * peggy_hours + 3 * laura_hours * bill_hours +
               9 * peggy_hours ** 2 + 8 * peggy_hours * bill_hours + 9 * bill_hours ** 2 +
               3 * laura_hours + 2 * peggy_hours + 9 * bill_hours, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(6 * laura_hours == 6, name="laura_paperwork")
m.addConstr(7 * laura_hours == 7, name="laura_quit")
m.addConstr(3 * peggy_hours == 3, name="peggy_paperwork")
m.addConstr(6 * peggy_hours == 6, name="peggy_quit")
m.addConstr(2 * bill_hours == 2, name="bill_paperwork")
m.addConstr(14 * bill_hours == 14, name="bill_quit")

m.addConstr(7 * laura_hours + 14 * bill_hours >= 20, name="laura_bill_quit")
m.addConstr(7 * laura_hours + 6 * peggy_hours + 14 * bill_hours >= 30, name="all_quit")
m.addConstr(3 * peggy_hours + 2 * bill_hours <= 92, name="peggy_bill_paperwork")
m.addConstr(6 * laura_hours + 3 * peggy_hours <= 100, name="laura_peggy_paperwork")
m.addConstr(6 * laura_hours + 3 * peggy_hours + 2 * bill_hours <= 100, name="all_paperwork")
m.addConstr(6 * peggy_hours + 14 * bill_hours <= 121, name="peggy_bill_quit")
m.addConstr(7 * laura_hours + 6 * peggy_hours + 14 * bill_hours <= 76, name="all_quit_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {laura_hours.varValue}")
    print(f"Hours worked by Peggy: {peggy_hours.varValue}")
    print(f"Hours worked by Bill: {bill_hours.varValue}")
else:
    print("No optimal solution found.")
