
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
tomatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tomatoes")
bowls_of_instant_ramen = m.addVar(lb=0, vtype=GRB.INTEGER, name="bowls_of_instant_ramen")
bagged_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
kale_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="kale_salads")

# Set objective function
m.setObjective(3 * tomatoes + 3 * bowls_of_instant_ramen + 8 * bagged_salads + 1 * kale_salads, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.32 * tomatoes + 0.58 * bagged_salads >= 33, "c0")
m.addConstr(0.32 * tomatoes + 0.04 * kale_salads >= 31, "c1")
m.addConstr(1.67 * bowls_of_instant_ramen + 0.04 * kale_salads >= 24, "c2")
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen >= 47, "c3")
m.addConstr(1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads >= 44, "c4")
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads + 0.04 * kale_salads >= 44, "c5")
m.addConstr(1.74 * bowls_of_instant_ramen + 0.08 * kale_salads >= 19, "c6")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen >= 33, "c7")
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads >= 39, "c8")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads >= 39, "c9")
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads >= 40, "c10")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads >= 40, "c11")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads + 0.08 * kale_salads >= 40, "c12")
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen >= 22, "c13")
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads >= 14, "c14")
m.addConstr(1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 19, "c15")
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 20, "c16")
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 20, "c17")
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 20, "c18")
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 22, "c19")
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 22, "c20")
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 22, "c21")
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 1.47 * kale_salads >= 14, "c22")
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads >= 14, "c23")
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 14, "c24")
m.addConstr(1.07 * tomatoes + 1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads >= 14, "c25")
m.addConstr(-8 * bowls_of_instant_ramen + 7 * bagged_salads >= 0, "c26")
m.addConstr(-1 * tomatoes + 6 * bowls_of_instant_ramen + 2 * bagged_salads >= 0, "c27")
m.addConstr(0.32 * tomatoes + 0.04 * kale_salads <= 58, "c28")
m.addConstr(1.67 * bowls_of_instant_ramen + 0.58 * bagged_salads <= 174, "c29")
m.addConstr(0.58 * bagged_salads + 0.04 * kale_salads <= 68, "c30")
m.addConstr(0.32 * tomatoes + 1.67 * bowls_of_instant_ramen <= 115, "c31")
m.addConstr(0.32 * tomatoes + 0.58 * bagged_salads + 0.04 * kale_salads <= 79, "c32")
m.addConstr(1.97 * tomatoes + 0.08 * kale_salads <= 59, "c33")
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads <= 139, "c34")
m.addConstr(1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads <= 48, "c35")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen <= 47, "c36")
m.addConstr(1.97 * tomatoes + 1.74 * bowls_of_instant_ramen + 1.21 * bagged_salads <= 140, "c37")
m.addConstr(1.97 * tomatoes + 1.21 * bagged_salads + 0.08 * kale_salads <= 70, "c38")
m.addConstr(1.07 * tomatoes + 0.11 * bagged_salads + 1.47 * kale_salads <= 39, "c39")
m.addConstr(1.31 * bowls_of_instant_ramen + 0.11 * bagged_salads + 1.47 * kale_salads <= 64, "c40")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

