
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(3 * cheeseburgers + 3 * oreos + 1 * bananas, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * cheeseburgers + 2 * oreos >= 8, "protein_constraint1")
m.addConstr(3 * oreos + 5 * bananas >= 46, "tastiness_constraint1")
m.addConstr(8 * cheeseburgers + 5 * bananas >= 35, "tastiness_constraint2")
m.addConstr(1 * cheeseburgers + 7 * bananas <= 60, "protein_constraint2")
m.addConstr(1 * cheeseburgers + 2 * oreos <= 47, "protein_constraint3")
m.addConstr(1 * cheeseburgers + 2 * oreos + 7 * bananas <= 47, "protein_constraint4")
m.addConstr(3 * oreos + 5 * bananas <= 113, "tastiness_constraint3")
m.addConstr(8 * cheeseburgers + 5 * bananas <= 105, "tastiness_constraint4")
m.addConstr(8 * cheeseburgers + 3 * oreos + 5 * bananas <= 105, "tastiness_constraint5")


# Add resource constraints based on the provided dictionary (optional, if these are the same as above)
resource_data = {'r0': {'description': 'grams of protein', 'upper_bound': 68, 'x0': 1, 'x1': 2, 'x2': 7}, 'r1': {'description': 'tastiness rating', 'upper_bound': 156, 'x0': 8, 'x1': 3, 'x2': 5}}

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cheeseburgers:', cheeseburgers.x)
    print('oreos:', oreos.x)
    print('bananas:', bananas.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

