
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    cheeseburgers = model.addVar(name="cheeseburgers", lb=0)  # Assuming non-negative
    oreos = model.addVar(name="oreos", lb=0)  # Assuming non-negative
    bananas = model.addVar(name="bananas", lb=0)  # Assuming non-negative

    # Objective function
    model.setObjective(3 * cheeseburgers + 3 * oreos + bananas, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(cheeseburgers + 2 * oreos >= 8, name="protein_cheeseburgers_oreos")
    model.addConstr(3 * oreos + 5 * bananas >= 46, name="tastiness_oreos_bananas")
    model.addConstr(8 * cheeseburgers + 5 * bananas >= 35, name="tastiness_cheeseburgers_bananas")
    model.addConstr(cheeseburgers + 7 * bananas <= 60, name="protein_cheeseburgers_bananas")
    model.addConstr(cheeseburgers + 2 * oreos <= 47, name="protein_cheeseburgers_oreos_max")
    model.addConstr(cheeseburgers + 2 * oreos + 7 * bananas <= 47, name="protein_all")
    model.addConstr(3 * oreos + 5 * bananas <= 113, name="tastiness_oreos_bananas_max")
    model.addConstr(8 * cheeseburgers + 5 * bananas <= 105, name="tastiness_cheeseburgers_bananas_max")
    model.addConstr(8 * cheeseburgers + 3 * oreos + 5 * bananas <= 105, name="tastiness_all")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Oreos: {oreos.varValue}")
        print(f"Bananas: {bananas.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
