
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(['peanutbutter sandwiches', 'steaks', 'rotisserie chickens', 'corn cobs', 'protein bars'], lb=0.0, ub=GRB.INFINITY, name="x")

# Set objective function
m.setObjective(5 * x['peanutbutter sandwiches'] + 1 * x['steaks'] + 3 * x['rotisserie chickens'] + 4 * x['corn cobs'] + 5 * x['protein bars'], GRB.MINIMIZE)

# Add resource constraints
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] + 7 * x['protein bars'] <= 269, "r0_tastiness")
m.addConstr(12 * x['peanutbutter sandwiches'] + 8 * x['steaks'] + 10 * x['rotisserie chickens'] + 1 * x['corn cobs'] + 2 * x['protein bars'] <= 234, "r1_sourness")
m.addConstr(14 * x['peanutbutter sandwiches'] + 8 * x['steaks'] + 11 * x['rotisserie chickens'] + 1 * x['corn cobs'] + 7 * x['protein bars'] <= 146, "r2_fiber")
m.addConstr(12 * x['peanutbutter sandwiches'] + 11 * x['steaks'] + 2 * x['rotisserie chickens'] + 7 * x['corn cobs'] + 14 * x['protein bars'] <= 157, "r3_protein")


# Add additional constraints
m.addConstr(2 * x['rotisserie chickens'] + 7 * x['protein bars'] >= 32)
m.addConstr(14 * x['steaks'] + 14 * x['corn cobs'] >= 43)
m.addConstr(14 * x['steaks'] + 7 * x['protein bars'] >= 48)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['corn cobs'] >= 33)
m.addConstr(2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 48)
m.addConstr(14 * x['corn cobs'] + 7 * x['protein bars'] >= 32)
m.addConstr(5 * x['peanutbutter sandwiches'] + 2 * x['rotisserie chickens'] >= 26)
m.addConstr(14 * x['steaks'] + 2 * x['rotisserie chickens'] >= 50)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] >= 18)
m.addConstr(14 * x['steaks'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 29)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] + 14 * x['corn cobs'] >= 29)
m.addConstr(5 * x['peanutbutter sandwiches'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 29)
m.addConstr(14 * x['steaks'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 35)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] + 14 * x['corn cobs'] >= 35)
m.addConstr(5 * x['peanutbutter sandwiches'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 35)
m.addConstr(14 * x['steaks'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 46)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] + 14 * x['corn cobs'] >= 46)
m.addConstr(5 * x['peanutbutter sandwiches'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] >= 46)
m.addConstr(5 * x['peanutbutter sandwiches'] + 14 * x['steaks'] + 2 * x['rotisserie chickens'] + 14 * x['corn cobs'] + 7 * x['protein bars'] >= 46)

# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
