
import gurobi as gp

m = gp.Model()

x0 = m.addVar(name="peanutbutter sandwiches", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="steaks", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="rotisserie chickens", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="corn cobs", lb=-gp.GRB.INFINITY)
x4 = m.addVar(name="protein bars", lb=-gp.GRB.INFINITY)

m.setObjective(5*x0 + x1 + 3*x2 + 4*x3 + 5*x4, gp.GRB.MINIMIZE)

m.addConstr(5*x0 + 14*x1 + 2*x2 + 14*x3 + 7*x4 <= 269)

m.addConstr(14*x1 + 2*x2 >= 32)
m.addConstr(14*x1 + 14*x3 >= 43)
m.addConstr(14*x1 + 7*x4 >= 48)
m.addConstr(5*x0 + 14*x3 >= 33)
m.addConstr(2*x2 + 14*x3 >= 48)
m.addConstr(14*x3 + 7*x4 >= 32)
m.addConstr(5*x0 + 2*x2 >= 26)
m.addConstr(14*x1 + 2*x2 >= 50)
m.addConstr(5*x0 + 14*x1 >= 18)
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 29)
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 29)
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 29)
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 35)
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 35)
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 35)
m.addConstr(14*x1 + 2*x2 + 14*x3 >= 46)
m.addConstr(5*x0 + 14*x1 + 14*x3 >= 46)
m.addConstr(5*x0 + 2*x2 + 14*x3 >= 46)
m.addConstr(5*x0 + 14*x1 + 2*x2 + 14*x3 + 7*x4 >= 46)

m.addConstr(12*x0 + 8*x1 + 10*x2 + x3 + 2*x4 <= 234)

m.addConstr(12*x0 + x3 >= 45)
m.addConstr(8*x1 + 2*x4 >= 25)
m.addConstr(12*x0 + 8*x1 >= 31)
m.addConstr(12*x0 + 2*x4 >= 18)
m.addConstr(12*x0 + 10*x2 + 2*x4 >= 46)
m.addConstr(12*x0 + 8*x1 + 10*x2 + x3 + 2*x4 >= 46)

m.addConstr(14*x0 + 8*x1 + 11*x2 + x3 + 7*x4 <= 146)

m.addConstr(14*x0 + 7*x4 >= 21)
m.addConstr(14*x0 + 8*x1 >= 12)
m.addConstr(8*x1 + 7*x4 >= 22)
m.addConstr(x3 + 7*x4 >= 25)

m.addConstr(12*x0 + 11*x1 + 2*x2 + 7*x3 + 14*x4 <= 157)

m.addConstr(11*x1 + 7*x3 >= 11)
m.addConstr(2*x2 + 7*x3 >= 25)
m.addConstr(12*x0 + 2*x2 >= 14)
m.addConstr(11*x1 + 2*x2 >= 18)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Peanutbutter sandwiches: ", x0.varValue)
    print("Steaks: ", x1.varValue)
    print("Rotisserie chickens: ", x2.varValue)
    print("Corn cobs: ", x3.varValue)
    print("Protein bars: ", x4.varValue)
else:
    print("No optimal solution found")
