
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - hours worked by each person
Dale_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")
Laura_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")
Bobby_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")

# Objective function: Minimize 1*Dale_hours + 8*Laura_hours + 7*Bobby_hours
m.setObjective(1 * Dale_hours + 8 * Laura_hours + 7 * Bobby_hours, GRB.MINIMIZE)

# Constraints based on the problem description

# Paperwork competence rating constraints
m.addConstr(Dale_hours * 3 + Bobby_hours * 6 >= 8, name="Paperwork_Dale_Bobby")
m.addConstr(Laura_hours * 7 + Bobby_hours * 6 >= 20, name="Paperwork_Laura_Bobby")
m.addConstr(Dale_hours * 3 + Laura_hours * 7 + Bobby_hours * 6 >= 20, name="Paperwork_All")
m.addConstr(Dale_hours * 3 + Bobby_hours * 6 <= 27, name="Paperwork_Dale_Bobby_Max")
m.addConstr(Dale_hours * 3 + Laura_hours * 7 <= 68, name="Paperwork_Dale_Laura_Max")
m.addConstr(Laura_hours * 7 + Bobby_hours * 6 <= 45, name="Paperwork_Laura_Bobby_Max")

# Work quality rating constraints
m.addConstr(Dale_hours * 9 + Laura_hours * 3 >= 31, name="WorkQuality_Dale_Laura")
m.addConstr(Dale_hours * 9 + Laura_hours * 3 + Bobby_hours * 2 >= 31, name="WorkQuality_All")
m.addConstr(Dale_hours * 9 + Laura_hours * 3 + Bobby_hours * 2 <= 77, name="WorkQuality_All_Max")

# Additional constraints
m.addConstr(6 * Dale_hours - 4 * Laura_hours >= 0, name="Dale_Laura_Constraint")
m.addConstr(-9 * Laura_hours + 4 * Bobby_hours >= 0, name="Laura_Bobby_Constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Dale hours: {Dale_hours.x}")
    print(f"Laura hours: {Laura_hours.x}")
    print(f"Bobby hours: {Bobby_hours.x}")
else:
    print("No optimal solution found")
