
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(x0 + 8 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x0 + 6 * x2 >= 8)
    model.addConstr(7 * x1 + 6 * x2 >= 20)
    model.addConstr(3 * x0 + 7 * x1 + 6 * x2 >= 20)
    model.addConstr(9 * x0 + 3 * x1 >= 31)
    model.addConstr(9 * x0 + 3 * x1 + 2 * x2 >= 31)
    model.addConstr(6 * x0 - 4 * x1 >= 0)
    model.addConstr(-9 * x1 + 4 * x2 >= 0)
    model.addConstr(3 * x0 + 6 * x2 <= 27)
    model.addConstr(3 * x0 + 7 * x1 <= 68)
    model.addConstr(7 * x1 + 6 * x2 <= 45)
    model.addConstr(9 * x0 + 3 * x1 + 2 * x2 <= 77)

    # Non-negativity constraints (implicit in Gurobi for continuous variables, but we require integers)
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize
    model.optimize()

    # Solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x0.varValue}")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is: ", model.status)

optimize_problem()
