
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize_Hours_Worked")

# Create variables
hank = model.addVar(vtype=GRB.INTEGER, name="hank")
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
paul = model.addVar(vtype=GRB.INTEGER, name="paul")
laura = model.addVar(vtype=GRB.INTEGER, name="laura")

# Set objective function
model.setObjective(9.01 * hank + 2.2 * ringo + 5.01 * paul + 4.0 * laura, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * hank <= 130, "c0")  # Not explicitly stated, but implied by the problem description
model.addConstr(13 * ringo <= 130, "c1") # Not explicitly stated, but implied by the problem description
model.addConstr(13 * paul <= 130, "c2") # Not explicitly stated, but implied by the problem description
model.addConstr(8 * laura <= 130, "c3") # Not explicitly stated, but implied by the problem description

model.addConstr(13 * ringo + 8 * laura >= 23, "c4")
model.addConstr(2 * hank + 13 * paul >= 22, "c5")
model.addConstr(2 * hank + 8 * laura >= 10, "c6")
model.addConstr(13 * ringo + 13 * paul + 8 * laura >= 19, "c7")
model.addConstr(2 * hank + 8 * laura <= 101, "c8")
model.addConstr(13 * paul + 8 * laura <= 74, "c9")
model.addConstr(2 * hank + 13 * paul <= 86, "c10")
model.addConstr(2 * hank + 13 * ringo <= 120, "c11")
model.addConstr(13 * ringo + 8 * laura <= 91, "c12")
model.addConstr(13 * ringo + 13 * paul <= 119, "c13")
model.addConstr(2 * hank + 13 * ringo + 8 * laura <= 47, "c14")
model.addConstr(13 * ringo + 13 * paul + 8 * laura <= 90, "c15")
model.addConstr(2 * hank + 13 * ringo + 13 * paul + 8 * laura <= 90, "c16")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Hank:', hank.x)
    print('Ringo:', ringo.x)
    print('Paul:', paul.x)
    print('Laura:', laura.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

