
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
H = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
R = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
P = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
L = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")

# Define the objective function
m.setObjective(9.01*H + 2.2*R + 5.01*P + 4.0*L, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*R + 8*L >= 23, name="constraint_1")
m.addConstr(2*H + 13*P >= 22, name="constraint_2")
m.addConstr(2*H + 8*L >= 10, name="constraint_3")
m.addConstr(13*R + 13*P + 8*L >= 19, name="constraint_4")
m.addConstr(2*H + 8*L <= 101, name="constraint_5")
m.addConstr(13*P + 8*L <= 74, name="constraint_6")
m.addConstr(2*H + 13*P <= 86, name="constraint_7")
m.addConstr(2*H + 13*R <= 120, name="constraint_8")
m.addConstr(13*R + 8*L <= 91, name="constraint_9")
m.addConstr(13*R + 13*P <= 119, name="constraint_10")
m.addConstr(2*H + 13*R + 8*L <= 47, name="constraint_11")
m.addConstr(13*R + 13*P + 8*L <= 90, name="constraint_12")
m.addConstr(2*H + 13*R + 13*P + 8*L <= 90, name="constraint_13")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print('Hours worked by Hank:', H.x)
    print('Hours worked by Ringo:', R.x)
    print('Hours worked by Paul:', P.x)
    print('Hours worked by Laura:', L.x)
else:
    print('No optimal solution found')
