
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    hours_worked_by_Hank = model.addVar(name="hours_worked_by_Hank", vtype=gurobi.GRB.INTEGER)
    hours_worked_by_Ringo = model.addVar(name="hours_worked_by_Ringo", vtype=gurobi.GRB.INTEGER)
    hours_worked_by_Paul = model.addVar(name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)
    hours_worked_by_Laura = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.01 * hours_worked_by_Hank + 2.2 * hours_worked_by_Ringo + 5.01 * hours_worked_by_Paul + 4.0 * hours_worked_by_Laura, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(13 * hours_worked_by_Ringo + 8 * hours_worked_by_Laura >= 23)
    model.addConstr(2 * hours_worked_by_Hank + 13 * hours_worked_by_Paul >= 22)
    model.addConstr(2 * hours_worked_by_Hank + 8 * hours_worked_by_Laura >= 10)
    model.addConstr(13 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul + 8 * hours_worked_by_Laura >= 19)
    model.addConstr(2 * hours_worked_by_Hank + 8 * hours_worked_by_Laura <= 101)
    model.addConstr(13 * hours_worked_by_Paul + 8 * hours_worked_by_Laura <= 74)
    model.addConstr(2 * hours_worked_by_Hank + 13 * hours_worked_by_Paul <= 86)
    model.addConstr(2 * hours_worked_by_Hank + 13 * hours_worked_by_Ringo <= 120)
    model.addConstr(13 * hours_worked_by_Ringo + 8 * hours_worked_by_Laura <= 91)
    model.addConstr(13 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul <= 119)
    model.addConstr(2 * hours_worked_by_Hank + 13 * hours_worked_by_Ringo + 8 * hours_worked_by_Laura <= 47)
    model.addConstr(13 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul + 8 * hours_worked_by_Laura <= 90)
    model.addConstr(2 * hours_worked_by_Hank + 13 * hours_worked_by_Ringo + 13 * hours_worked_by_Paul + 8 * hours_worked_by_Laura <= 90)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
        print(f"Hours worked by Ringo: {hours_worked_by_Ringo.varValue}")
        print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
        print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
