
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
medical_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="x0")
transportation_companies = m.addVar(vtype=gp.GRB.INTEGER, name="x1")
military_intelligence_companies = m.addVar(vtype=gp.GRB.INTEGER, name="x2")
logistics_companies = m.addVar(vtype=gp.GRB.INTEGER, name="x3")
signal_platoons = m.addVar(vtype=gp.GRB.INTEGER, name="x4")

# Set objective function
m.setObjective(4.98 * medical_platoons + 8.23 * transportation_companies + 1.79 * military_intelligence_companies + 7.38 * logistics_companies + 4.81 * signal_platoons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * military_intelligence_companies + 13 * logistics_companies >= 36)
m.addConstr(17 * medical_platoons + 5 * signal_platoons >= 26)
m.addConstr(13 * logistics_companies + 5 * signal_platoons >= 27)
m.addConstr(2 * transportation_companies + 5 * signal_platoons >= 31)
m.addConstr(2 * transportation_companies + 12 * military_intelligence_companies >= 54)
m.addConstr(17 * medical_platoons + 12 * military_intelligence_companies + 5 * signal_platoons >= 30)
m.addConstr(2 * transportation_companies + 13 * logistics_companies + 5 * signal_platoons >= 30)
m.addConstr(17 * medical_platoons + 12 * military_intelligence_companies + 5 * signal_platoons >= 44)
m.addConstr(2 * transportation_companies + 13 * logistics_companies + 5 * signal_platoons >= 44)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 12 * military_intelligence_companies + 13 * logistics_companies + 5 * signal_platoons >= 44)

m.addConstr(17 * medical_platoons + 2 * transportation_companies >= 40)
m.addConstr(17 * medical_platoons + 18 * logistics_companies >= 30)
m.addConstr(2 * transportation_companies + 3 * military_intelligence_companies >= 40)
m.addConstr(18 * logistics_companies + 8 * signal_platoons >= 18)
m.addConstr(17 * medical_platoons + 8 * signal_platoons >= 30)
m.addConstr(2 * transportation_companies + 8 * signal_platoons >= 46)
m.addConstr(17 * medical_platoons + 3 * military_intelligence_companies >= 38)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 18 * logistics_companies >= 44)
m.addConstr(2 * transportation_companies + 3 * military_intelligence_companies + 8 * signal_platoons >= 44)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 3 * military_intelligence_companies >= 44)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 18 * logistics_companies >= 43)
m.addConstr(2 * transportation_companies + 3 * military_intelligence_companies + 8 * signal_platoons >= 43)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 3 * military_intelligence_companies >= 43)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 18 * logistics_companies >= 37)
m.addConstr(2 * transportation_companies + 3 * military_intelligence_companies + 8 * signal_platoons >= 37)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 3 * military_intelligence_companies >= 37)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 3 * military_intelligence_companies + 18 * logistics_companies + 8 * signal_platoons >= 37)


m.addConstr(10 * medical_platoons - 7 * transportation_companies >= 0)
m.addConstr(3 * logistics_companies - 1 * signal_platoons >= 0)
m.addConstr(1 * medical_platoons + 5 * military_intelligence_companies - 2 * logistics_companies >= 0)

m.addConstr(17 * medical_platoons + 5 * signal_platoons <= 244)
m.addConstr(2 * transportation_companies + 13 * logistics_companies <= 263)
m.addConstr(17 * medical_platoons + 13 * logistics_companies <= 68)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 5 * signal_platoons <= 206)
m.addConstr(17 * medical_platoons + 2 * transportation_companies + 12 * military_intelligence_companies <= 93)
m.addConstr(2 * transportation_companies + 13 * logistics_companies + 5 * signal_platoons <= 143)
m.addConstr(12 * military_intelligence_companies + 13 * logistics_companies + 5 * signal_platoons <= 172)
m.addConstr(17 * medical_platoons + 12 * military_intelligence_companies + 13 * logistics_companies <= 243)

m.addConstr(2 * transportation_companies + 3 * military_intelligence_companies <= 144)
m.addConstr(17 * medical_platoons + 8 * signal_platoons <= 125)
m.addConstr(3 * military_intelligence_companies + 18 * logistics_companies <= 164)
m.addConstr(18 * logistics_companies + 8 * signal_platoons <= 116)
m.addConstr(17 * medical_platoons + 18 * logistics_companies <= 184)
m.addConstr(17 * medical_platoons + 2 * transportation_companies <= 207)
m.addConstr(2 * transportation_companies + 18 * logistics_companies <= 63)
m.addConstr(17 * medical_platoons + 3 * military_intelligence_companies <= 187)
m.addConstr(3 * military_intelligence_companies + 8 * signal_platoons <= 227)
m.addConstr(3 * military_intelligence_companies + 18 * logistics_companies + 8 * signal_platoons <= 85)
m.addConstr(17 * medical_platoons + 18 * logistics_companies + 8 * signal_platoons <= 129)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

