
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
peggy_hours = m.addVar(lb=0, name="peggy_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")
john_hours = m.addVar(lb=0, name="john_hours")

# Set objective function
m.setObjective(1 * peggy_hours + 5 * dale_hours + 2 * john_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * peggy_hours + 6 * john_hours >= 71, "c0")
m.addConstr(2 * dale_hours + 6 * john_hours >= 34, "c1")
m.addConstr(20 * peggy_hours + 2 * dale_hours + 6 * john_hours >= 34, "c2")
m.addConstr(9 * peggy_hours + 19 * john_hours >= 105, "c3")
m.addConstr(6 * dale_hours + 19 * john_hours >= 99, "c4")
m.addConstr(9 * peggy_hours + 6 * dale_hours + 19 * john_hours >= 99, "c5")
m.addConstr(13 * peggy_hours + 22 * dale_hours >= 56, "c6")
m.addConstr(13 * peggy_hours + 15 * john_hours >= 79, "c7")
m.addConstr(22 * dale_hours + 15 * john_hours >= 90, "c8")
m.addConstr(13 * peggy_hours + 22 * dale_hours + 15 * john_hours >= 90, "c9")
m.addConstr(10 * peggy_hours + 14 * dale_hours >= 105, "c10")
m.addConstr(10 * peggy_hours + 12 * john_hours >= 109, "c11")
m.addConstr(14 * dale_hours + 12 * john_hours >= 54, "c12")
m.addConstr(10 * peggy_hours + 14 * dale_hours + 12 * john_hours >= 88, "c13")
m.addConstr(4 * peggy_hours + 8 * john_hours >= 30, "c14")
m.addConstr(4 * peggy_hours + 12 * dale_hours + 8 * john_hours >= 30, "c15")
m.addConstr(7 * peggy_hours - 10 * dale_hours >= 0, "c16")
m.addConstr(-10 * peggy_hours + 5 * john_hours >= 0, "c17")
m.addConstr(9 * peggy_hours + 6 * dale_hours <= 273, "c18")
m.addConstr(9 * peggy_hours + 19 * john_hours <= 204, "c19")
m.addConstr(13 * peggy_hours + 22 * dale_hours <= 214, "c20")
m.addConstr(22 * dale_hours + 15 * john_hours <= 190, "c21")
m.addConstr(13 * peggy_hours + 22 * dale_hours + 15 * john_hours <= 211, "c22")
m.addConstr(12 * dale_hours + 8 * john_hours <= 73, "c23")
m.addConstr(4 * peggy_hours + 8 * john_hours <= 139, "c24")
m.addConstr(4 * peggy_hours + 12 * dale_hours + 8 * john_hours <= 60, "c25")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
    print('John Hours: %g' % john_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
