
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(name="hours_worked_by_Peggy")
x1 = m.addVar(name="hours_worked_by_Dale")
x2 = m.addVar(name="hours_worked_by_John")

# Objective function: minimize 1*x0 + 5*x1 + 2*x2
m.setObjective(1*x0 + 5*x1 + 2*x2, GRB.MINIMIZE)

# Constraints based on the problem description

# Organization score constraints
m.addConstr(20*x0 + 6*x2 >= 71)
m.addConstr(2*x1 + 6*x2 >= 34)
m.addConstr(20*x0 + 2*x1 + 6*x2 >= 34)

# Paperwork competence rating constraints
m.addConstr(9*x0 + 19*x2 >= 105)
m.addConstr(6*x1 + 19*x2 >= 99)
m.addConstr(9*x0 + 6*x1 + 19*x2 >= 99)
m.addConstr(9*x0 + 6*x1 <= 273) # Maximum constraint
m.addConstr(9*x0 + 19*x2 <= 204) # Maximum constraint

# Productivity rating constraints
m.addConstr(13*x0 + 22*x1 >= 56)
m.addConstr(13*x0 + 15*x2 >= 79)
m.addConstr(22*x1 + 15*x2 >= 90)
m.addConstr(13*x0 + 22*x1 + 15*x2 >= 90)
m.addConstr(13*x0 + 22*x1 <= 214) # Maximum constraint
m.addConstr(22*x1 + 15*x2 <= 190) # Maximum constraint
m.addConstr(13*x0 + 22*x1 + 15*x2 <= 211) # Maximum constraint

# Likelihood to quit index constraints
m.addConstr(10*x0 + 14*x1 >= 105)
m.addConstr(10*x0 + 12*x2 >= 109)
m.addConstr(14*x1 + 12*x2 >= 54)
m.addConstr(10*x0 + 14*x1 + 12*x2 >= 88)

# Computer competence rating constraints
m.addConstr(4*x0 + 8*x2 >= 30)
m.addConstr(4*x0 + 12*x1 + 8*x2 >= 30)
m.addConstr(12*x1 + 8*x2 <= 73) # Maximum constraint
m.addConstr(4*x0 + 8*x2 <= 139) # Maximum constraint
m.addConstr(4*x0 + 12*x1 + 8*x2 <= 60) # Maximum constraint

# Additional linear constraints
m.addConstr(7*x0 - 10*x1 >= 0)
m.addConstr(-10*x0 + 5*x2 >= 0)

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
