
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
peggy_hours = m.addVar(name="peggy_hours", lb=0)  # hours worked by Peggy
dale_hours = m.addVar(name="dale_hours", lb=0)   # hours worked by Dale
john_hours = m.addVar(name="john_hours", lb=0)   # hours worked by John

# Objective function: Minimize 1*peggy_hours + 5*dale_hours + 2*john_hours
m.setObjective(peggy_hours + 5 * dale_hours + 2 * john_hours, gp.GRB.MINIMIZE)

# Constraints
# Fixed ratings
m.addConstraint(peggy_hours * 20 + dale_hours * 2 + john_hours * 6 >= 71)  # Organization score combined Peggy, John
m.addConstraint(dale_hours * 2 + john_hours * 6 >= 34)  # Organization score combined Dale, John
m.addConstraint(peggy_hours * 20 + dale_hours * 2 + john_hours * 6 >= 34)  # Organization score combined all

m.addConstraint(peggy_hours * 9 + john_hours * 19 >= 105)  # Paperwork competence rating combined Peggy, John
m.addConstraint(dale_hours * 6 + john_hours * 19 >= 99)  # Paperwork competence rating combined Dale, John
m.addConstraint(peggy_hours * 9 + dale_hours * 6 + john_hours * 19 >= 99)  # Paperwork competence rating combined all

m.addConstraint(peggy_hours * 13 + dale_hours * 22 >= 56)  # Productivity rating combined Peggy, Dale
m.addConstraint(peggy_hours * 13 + john_hours * 15 >= 79)  # Productivity rating combined Peggy, John
m.addConstraint(dale_hours * 22 + john_hours * 15 >= 90)  # Productivity rating combined Dale, John
m.addConstraint(peggy_hours * 13 + dale_hours * 22 + john_hours * 15 >= 90)  # Productivity rating combined all

m.addConstraint(peggy_hours * 10 + dale_hours * 14 >= 105)  # Likelihood to quit index combined Peggy, Dale
m.addConstraint(peggy_hours * 10 + john_hours * 12 >= 109)  # Likelihood to quit index combined Peggy, John
m.addConstraint(dale_hours * 14 + john_hours * 12 >= 54)  # Likelihood to quit index combined Dale, John
m.addConstraint(peggy_hours * 10 + dale_hours * 14 + john_hours * 12 >= 88)  # Likelihood to quit index combined all

m.addConstraint(peggy_hours * 4 + john_hours * 8 >= 30)  # Computer competence rating combined Peggy, John
m.addConstraint(peggy_hours * 4 + dale_hours * 12 + john_hours * 8 >= 30)  # Computer competence rating combined all

m.addConstraint(7 * peggy_hours - 10 * dale_hours >= 0)  # Constraint 32
m.addConstraint(-10 * peggy_hours + 5 * john_hours >= 0)  # Constraint 33

m.addConstraint(peggy_hours * 9 + dale_hours * 6 <= 273)  # Paperwork competence rating combined Peggy, Dale
m.addConstraint(peggy_hours * 9 + john_hours * 19 <= 204)  # Paperwork competence rating combined Peggy, John

m.addConstraint(peggy_hours * 13 + dale_hours * 22 <= 214)  # Productivity rating combined Peggy, Dale
m.addConstraint(dale_hours * 22 + john_hours * 15 <= 190)  # Productivity rating combined Dale, John
m.addConstraint(peggy_hours * 13 + dale_hours * 22 + john_hours * 15 <= 211)  # Productivity rating combined all

m.addConstraint(dale_hours * 12 + john_hours * 8 <= 73)  # Computer competence rating combined Dale, John
m.addConstraint(peggy_hours * 4 + john_hours * 8 <= 139)  # Computer competence rating combined Peggy, John
m.addConstraint(peggy_hours * 4 + dale_hours * 12 + john_hours * 8 <= 60)  # Computer competence rating combined all

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Peggy: {peggy_hours.varValue}")
    print(f"Hours worked by Dale: {dale_hours.varValue}")
    print(f"Hours worked by John: {john_hours.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
