
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
peggy = model.addVar(vtype=GRB.CONTINUOUS, name="Peggy")
john = model.addVar(vtype=GRB.CONTINUOUS, name="John")
dale = model.addVar(vtype=GRB.CONTINUOUS, name="Dale")
bill = model.addVar(vtype=GRB.CONTINUOUS, name="Bill")


# Set objective function
model.setObjective(9 * peggy + 7 * john + 4 * dale + 5 * bill, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * dale + 15 * bill >= 14, "c1")
model.addConstr(11 * peggy + 2 * dale >= 20, "c2")
model.addConstr(1 * john + 2 * dale >= 17, "c3")
model.addConstr(11 * peggy + 1 * john + 2 * dale + 15 * bill >= 17, "c4")
model.addConstr(8 * peggy - 4 * john >= 0, "c5")
model.addConstr(1 * john + 15 * bill <= 38, "c6")


# Optimize model
model.optimize()

if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

