
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables as continuous (since fractional hours are allowed)
Peggy, John, Dale, Bill = m.addVars(4, lb=0, vtype=GRB.CONTINUOUS)

# Objective function to minimize
m.setObjective(9 * Peggy + 7 * John + 4 * Dale + 5 * Bill, GRB.MINIMIZE)

# Constraints
# 1. Total combined dollar cost per hour from hours worked by Dale and hours worked by Bill must be at least 14.
m.addConstr(2 * Dale + 15 * Bill >= 14, name="Dale_Bill_cost_min")

# 2. Total combined dollar cost per hour from hours worked by Peggy and hours worked by Dale should be greater than or equal to 20.
m.addConstr(11 * Peggy + 2 * Dale >= 20, name="Peggy_Dale_cost_min")

# 3. Total combined dollar cost per hour from hours worked by John plus hours worked by Dale should be at least 17.
m.addConstr(1 * John + 2 * Dale >= 17, name="John_Dale_cost_min")

# 4. Total combined dollar cost per hour from all workers has to be at least 17.
m.addConstr(11 * Peggy + 1 * John + 2 * Dale + 15 * Bill >= 17, name="All_workers_cost_min")

# 5. Eight times the number of hours worked by Peggy, plus -4 times the number of hours worked by John must be at minimum zero.
m.addConstr(8 * Peggy - 4 * John >= 0, name="Peggy_John_hours_rel")

# 6. The total combined dollar cost per hour from hours worked by John and hours worked by Bill must be at most 38.
m.addConstr(1 * John + 15 * Bill <= 38, name="John_Bill_cost_max")

# Optimize the model
m.optimize()
