
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    peggy_hours = model.addVar(name="peggy_hours", lb=0, ub=None)
    john_hours = model.addVar(name="john_hours", lb=0, ub=None)
    dale_hours = model.addVar(name="dale_hours", lb=0, ub=None)
    bill_hours = model.addVar(name="bill_hours", lb=0, ub=None)

    # Define objective function
    model.setObjective(9 * peggy_hours + 7 * john_hours + 4 * dale_hours + 5 * bill_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    # 1. Individual dollar costs per hour (not explicitly needed as they are part of the objective function)
    # 2. The total combined dollar cost per hour from hours worked by Dale and Bill must be at least $14.
    model.addConstr(2 * dale_hours + 15 * bill_hours >= 14, name="dale_bill_cost")
    # 3. The total combined dollar cost per hour from hours worked by Peggy and Dale must be at least $20.
    model.addConstr(11 * peggy_hours + 2 * dale_hours >= 20, name="peggy_dale_cost")
    # 4. The total combined dollar cost per hour from hours worked by John and Dale must be at least $17.
    model.addConstr(1 * john_hours + 2 * dale_hours >= 17, name="john_dale_cost")
    # 5. The total combined dollar cost per hour from hours worked by all four must be at least $17.
    model.addConstr(11 * peggy_hours + 1 * john_hours + 2 * dale_hours + 15 * bill_hours >= 17, name="total_cost")
    # 6. 8 * (hours worked by Peggy) - 4 * (hours worked by John) must be at least 0.
    model.addConstr(8 * peggy_hours - 4 * john_hours >= 0, name="peggy_john_constraint")
    # 7. The total combined dollar cost per hour from hours worked by John and Bill must be at most $38.
    model.addConstr(1 * john_hours + 15 * bill_hours <= 38, name="john_bill_cost")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peggy hours: {peggy_hours.varValue}")
        print(f"John hours: {john_hours.varValue}")
        print(f"Dale hours: {dale_hours.varValue}")
        print(f"Bill hours: {bill_hours.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
