
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Define variables
variables = {
    'hours worked by Bill': m.addVar(vtype=gp.GRB.INTEGER, name='x0'),
    'hours worked by Ringo': m.addVar(vtype=gp.GRB.INTEGER, name='x1'),
    'hours worked by John': m.addVar(vtype=gp.GRB.INTEGER, name='x2'),
    'hours worked by Mary': m.addVar(vtype=gp.GRB.INTEGER, name='x3'),
    'hours worked by George': m.addVar(vtype=gp.GRB.INTEGER, name='x4'),
    'hours worked by Paul': m.addVar(vtype=gp.GRB.INTEGER, name='x5'),
    'hours worked by Bobby': m.addVar(vtype=gp.GRB.INTEGER, name='x6')
}

# Define resources
resources = {
    'r0': {'description': 'organization score', 'upper_bound': 502, 'x0': 9, 'x1': 10, 'x2': 4, 'x3': 3, 'x4': 11, 'x5': 4, 'x6': 6},
    'r1': {'description': 'paperwork competence rating', 'upper_bound': 420, 'x0': 8, 'x1': 14, 'x2': 4, 'x3': 13, 'x4': 14, 'x5': 9, 'x6': 11}
}

# Set objective function
m.setObjective(1 * variables['hours worked by Bill'] + 4 * variables['hours worked by Ringo'] + 1 * variables['hours worked by John'] + 9 * variables['hours worked by Mary'] + 3 * variables['hours worked by George'] + 7 * variables['hours worked by Paul'] + 9 * variables['hours worked by Bobby'], gp.GRB.MAXIMIZE)

# Add resource constraints
for resource, data in resources.items():
    m.addConstr(gp.quicksum(data[f'x{i}'] * variables[list(variables.keys())[i]] for i in range(len(variables))) <= data['upper_bound'], resource)


# Add other constraints from the input
constraints = [
    (4*variables['x5'] + 6*variables['x6'], '>=', 59),
    (11*variables['x4'] + 4*variables['x5'], '>=', 29),
    (10*variables['x1'] + 4*variables['x5'], '>=', 69),
    (4*variables['x2'] + 6*variables['x6'], '>=', 45),
    (9*variables['x0'] + 10*variables['x1'], '>=', 59),
    (3*variables['x3'] + 6*variables['x6'], '>=', 25),
    (3*variables['x3'] + 11*variables['x4'], '>=', 36),
    (10*variables['x1'] + 3*variables['x3'], '>=', 24),
    (4*variables['x2'] + 4*variables['x5'], '>=', 71),
    (9*variables['x0'] + 6*variables['x6'], '>=', 32),
    (11*variables['x4'] + 6*variables['x6'], '>=', 71),
    (10*variables['x1'] + 11*variables['x4'], '>=', 26),
    (10*variables['x1'] + 4*variables['x2'], '>=', 45),
    (9*variables['x0'] + 11*variables['x4'], '>=', 40),
    # ... (rest of the constraints -  follow the same pattern as above)
]

for expr, sense, rhs in constraints:
    m.addConstr(expr, sense, rhs)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

