
from gurobipy import *

# Create a new model
m = Model("Hours_Worked")

# Define variables for hours worked by each person
Bill = m.addVar(lb=0, vtype=GRB.INTEGER, name="Bill")
Ringo = m.addVar(lb=0, vtype=GRB.INTEGER, name="Ringo")
John = m.addVar(lb=0, vtype=GRB.INTEGER, name="John")
Mary = m.addVar(lb=35, vtype=GRB.INTEGER, name="Mary")  # Mary must work at least 35 hours
George = m.addVar(lb=0, vtype=GRB.INTEGER, name="George")
Paul = m.addVar(lb=0, vtype=GRB.INTEGER, name="Paul")
Bobby = m.addVar(lb=0, vtype=GRB.INTEGER, name="Bobby")

# Add constraints for total hours worked by each pair or group of people
m.addConstr(Bill + Ringo <= 103, "Bill_Ringo_Paul_max")
m.addConstr(Bill + Mary + Paul <= 184, "Bill_Mary_Paul_max")
m.addConstr(Ringo + Mary + Bobby <= 217, "Ringo_Mary_Bobby_max")
m.addConstr(Mary + George + Bobby <= 337, "Mary_George_Bobby_max")

# Add constraints for total hours worked by each person
m.addConstr(Bill >= 0, "Bill_min")
m.addConstr(Ringo >= 0, "Ringo_min")
m.addConstr(John >= 0, "John_min")
m.addConstr(Mary >= 35, "Mary_min")  # Mary must work at least 35 hours
m.addConstr(George >= 0, "George_min")
m.addConstr(Paul >= 0, "Paul_min")
m.addConstr(Bobby >= 0, "Bobby_min")

# Objective function: minimize the total hours worked by all people
m.setObjective(Bill + Ringo + John + Mary + George + Paul + Bobby, GRB.MINIMIZE)

# Update the model
m.update()

# Optimize the model
m.optimize()
