
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
black_pens = m.addVar(name="black_pens", vtype=gp.GRB.INTEGER)
headsets = m.addVar(name="headsets", vtype=gp.GRB.INTEGER)
mechanical_pencils = m.addVar(name="mechanical_pencils", vtype=gp.GRB.INTEGER)
lanyards = m.addVar(name="lanyards", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4 * black_pens + 4 * headsets + 8 * mechanical_pencils + 9 * lanyards, gp.GRB.MINIMIZE)

# Constraints
# Sustainability score constraints
m.addConstr(20 * headsets + 2 * lanyards >= 51, name="sustainability_score_headsets_lanyards")
m.addConstr(9 * black_pens + 20 * headsets + 10 * mechanical_pencils >= 90, name="sustainability_score_black_pens_headsets_pencils")
m.addConstr(9 * black_pens + 20 * headsets + 10 * mechanical_pencils + 2 * lanyards >= 90, name="sustainability_score_all")
m.addConstr(9 * black_pens + 2 * lanyards <= 261, name="sustainability_score_black_pens_lanyards")
m.addConstr(10 * mechanical_pencils + 2 * lanyards <= 341, name="sustainability_score_pencils_lanyards")
m.addConstr(20 * headsets + 2 * lanyards <= 153, name="sustainability_score_headsets_lanyards_max")
m.addConstr(20 * headsets + 10 * mechanical_pencils <= 136, name="sustainability_score_headsets_pencils_max")
m.addConstr(9 * black_pens + 10 * mechanical_pencils <= 100, name="sustainability_score_black_pens_pencils_max")
m.addConstr(9 * black_pens + 20 * headsets + 2 * lanyards <= 182, name="sustainability_score_black_pens_headsets_lanyards_max")
m.addConstr(9 * black_pens + 20 * headsets + 10 * mechanical_pencils <= 208, name="sustainability_score_all_max")

# Workplace safety impact constraints
m.addConstr(16 * headsets + 7 * lanyards >= 28, name="workplace_safety_headsets_lanyards")
m.addConstr(16 * headsets + 17 * mechanical_pencils >= 45, name="workplace_safety_headsets_pencils")
m.addConstr(17 * mechanical_pencils + 7 * lanyards >= 66, name="workplace_safety_pencils_lanyards")
m.addConstr(10 * black_pens + 16 * headsets + 17 * mechanical_pencils + 7 * lanyards >= 66, name="workplace_safety_all")
m.addConstr(10 * black_pens + 17 * mechanical_pencils <= 180, name="workplace_safety_black_pens_pencils_max")
m.addConstr(10 * black_pens + 16 * headsets <= 281, name="workplace_safety_black_pens_headsets_max")
m.addConstr(10 * black_pens + 7 * lanyards <= 197, name="workplace_safety_black_pens_lanyards_max")
m.addConstr(10 * black_pens + 16 * headsets + 17 * mechanical_pencils <= 107, name="workplace_safety_all_max")
m.addConstr(10 * black_pens + 16 * headsets + 7 * lanyards <= 216, name="workplace_safety_black_pens_headsets_lanyards_max")

# Usefulness rating constraints
m.addConstr(16 * black_pens + 9 * lanyards >= 73, name="usefulness_rating_black_pens_lanyards")
m.addConstr(16 * black_pens + mechanical_pencils >= 72, name="usefulness_rating_black_pens_pencils")
m.addConstr(16 * black_pens + 12 * headsets >= 56, name="usefulness_rating_black_pens_headsets")
m.addConstr(12 * headsets + mechanical_pencils >= 62, name="usefulness_rating_headsets_pencils")
m.addConstr(16 * black_pens + 12 * headsets + mechanical_pencils + 9 * lanyards >= 62, name="usefulness_rating_all")
m.addConstr(16 * black_pens + 9 * lanyards <= 332, name="usefulness_rating_black_pens_lanyards_max")
m.addConstr(12 * headsets + mechanical_pencils <= 309, name="usefulness_rating_headsets_pencils_max")
m.addConstr(16 * black_pens + 12 * headsets <= 235, name="usefulness_rating_black_pens_headsets_max")

# Other constraints
m.addConstr(-7 * black_pens + 3 * headsets >= 0, name="other_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Black Pens: ", black_pens.varValue)
    print("Headsets: ", headsets.varValue)
    print("Mechanical Pencils: ", mechanical_pencils.varValue)
    print("Lanyards: ", lanyards.varValue)
else:
    print("The model is infeasible")
