
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
george_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hank_hours")

# Set objective function
m.setObjective(7.93 * george_hours + 3.2 * peggy_hours + 4.75 * hank_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * peggy_hours + 7 * hank_hours >= 12, "work_quality_peggy_hank")
m.addConstr(2 * george_hours + 9 * peggy_hours + 7 * hank_hours >= 12, "work_quality_total")

m.addConstr(9 * peggy_hours + 6 * hank_hours >= 25, "paperwork_peggy_hank")
m.addConstr(5 * george_hours + 9 * peggy_hours + 6 * hank_hours >= 16, "paperwork_total") # Combined constraint

m.addConstr(9 * george_hours + 6 * peggy_hours >= 10, "productivity_george_peggy")
m.addConstr(9 * george_hours + 3 * hank_hours >= 14, "productivity_george_hank")
m.addConstr(9 * george_hours + 6 * peggy_hours + 3 * hank_hours >= 14, "productivity_total")

m.addConstr(6 * george_hours - 4 * peggy_hours >= 0, "george_peggy_relation")
m.addConstr(-10 * peggy_hours + 2 * hank_hours >= 0, "peggy_hank_relation")

m.addConstr(5 * george_hours + 9 * peggy_hours <= 38, "paperwork_george_peggy_max")
m.addConstr(9 * george_hours + 3 * hank_hours <= 31, "productivity_george_hank_max")
m.addConstr(6 * peggy_hours + 3 * hank_hours <= 53, "productivity_peggy_hank_max")
m.addConstr(9 * george_hours + 6 * peggy_hours <= 72, "productivity_george_peggy_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('George hours:', george_hours.x)
    print('Peggy hours:', peggy_hours.x)
    print('Hank hours:', hank_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

