
import gurobi

def optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    G = m.addVar(name="George", lb=0)  # hours worked by George (non-integer)
    P = m.addVar(name="Peggy", lb=0, integrality=1)  # hours worked by Peggy (integer)
    H = m.addVar(name="Hank", lb=0, integrality=1)  # hours worked by Hank (integer)

    # Objective function
    m.setObjective(7.93 * G + 3.2 * P + 4.75 * H, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual ratings (not actually constraints since they are fixed)
    # George's ratings
    # m.addConstr(2 * G <= 53)  # Not needed as it's a fixed value
    # m.addConstr(5 * G <= 76)  # Not needed as it's a fixed value
    # m.addConstr(9 * G <= 72)  # Not needed as it's a fixed value

    # Combined ratings constraints
    m.addConstr(9 * P + 7 * H >= 12)  # Work quality
    m.addConstr(2 * G + 9 * P + 7 * H >= 12)  # Work quality
    m.addConstr(9 * P + 6 * H >= 25)  # Paperwork competence
    m.addConstr(5 * G + 9 * P + 6 * H >= 16)  # Paperwork competence (also >= 16)
    m.addConstr(9 * G + 6 * P >= 10)  # Productivity
    m.addConstr(9 * G + 3 * H >= 14)  # Productivity
    m.addConstr(9 * G + 6 * P + 3 * H >= 14)  # Productivity

    # Linear constraints
    m.addConstr(6 * G - 4 * P >= 0)
    m.addConstr(-10 * P + 2 * H >= 0)

    # Bounds on combined ratings
    m.addConstr(5 * G + 9 * P <= 38)  # Paperwork competence
    m.addConstr(9 * G + 3 * H <= 31)  # Productivity
    m.addConstr(6 * P + 3 * H <= 53)  # Productivity
    m.addConstr(9 * G + 6 * P <= 72)  # Productivity

    # Solve the problem
    m.optimize()

    # Print the solution
    if m.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", m.objVal)
        print("George: ", G.varValue)
        print("Peggy: ", P.varValue)
        print("Hank: ", H.varValue)
    else:
        print("No solution found")

optimization_problem()
