
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (hours worked by each person)
Hank = m.addVar(lb=0, name="Hank")
Dale = m.addVar(lb=0, name="Dale")
Jean = m.addVar(lb=0, name="Jean")
George = m.addVar(lb=0, name="George")

# Objective function
m.setObjective(6.35 * Hank**2 + 9.71 * Hank * Dale + 8.11 * Hank * Jean +
               4.03 * Dale * Jean + 7.08 * Dale * George + 1.55 * George**2 +
               3.05 * Hank + 5.16 * Jean, GRB.MINIMIZE)

# Constraints
m.addConstr(Hank >= 0) # No lower bound explicitly given for hours worked

# Paperwork competence rating constraints
m.addConstr(1 * Hank**2 + 11 * Jean**2 >= 41)
m.addConstr(6 * Dale + 11 * Jean >= 41)
m.addConstr(6 * Dale + 6 * George >= 41)
m.addConstr(Hank**2 + 6 * Dale**2 >= 29)
m.addConstr(Hank**2 + 6 * Dale**2 + 11 * Jean**2 >= 26)
m.addConstr(1 * Hank + 11 * Jean + 6 * George >= 26)
m.addConstr(1 * Hank + 6 * Dale + 11 * Jean >= 43)
m.addConstr(Hank + 11 * Jean + 6 * George >= 43)
m.addConstr(Hank + 6 * Dale + 11 * Jean + 6 * George >= 43)

# Organization score constraints
m.addConstr(23 * Hank + 11 * Dale >= 30)
m.addConstr(5 * Jean + 16 * George >= 29)
m.addConstr((23 * Hank)**2 + (5 * Jean)**2 >= 21)
m.addConstr(23 * Hank + 11 * Dale + 5 * Jean + 16 * George >= 21)

# Work quality rating constraints
m.addConstr(22 * Hank + 2 * George >= 26)
m.addConstr(22 * Hank + 5 * Dale + 14 * Jean + 2 * George >= 26)

# Dollar cost per hour constraints
m.addConstr(13 * Dale + 7 * Jean >= 47)
m.addConstr((19 * Hank)**2 + (13 * Dale)**2 >= 19)
m.addConstr((7 * Jean)**2 + (22 * George)**2 >= 39)
m.addConstr(13 * Dale + 22 * George >= 18)
m.addConstr(19 * Hank + 13 * Dale + 7 * Jean + 22 * George >= 18)

# Upper bound constraints
m.addConstr(Hank**2 + 11 * Jean**2 <= 165)
m.addConstr(6 * Dale**2 + 11 * Jean**2 + 6 * George**2 <= 178)
m.addConstr(23 * Hank + 11 * Dale + 16 * George <= 137)
m.addConstr((23 * Hank)**2 + (5 * Jean)**2 + (16 * George)**2 <= 88)
m.addConstr(22 * Hank + 2 * George <= 121)
m.addConstr(14 * Jean + 2 * George <= 144)
m.addConstr((5 * Dale)**2 + (2 * George)**2 <= 170)
m.addConstr((19 * Hank)**2 + (13 * Dale)**2 + (22 * George)**2 <= 90)
m.addConstr((13 * Dale)**2 + (7 * Jean)**2 + (22 * George)**2 <= 55)
m.addConstr(19 * Hank + 13 * Dale + 7 * Jean <= 146)
m.addConstr(19 * Hank + 7 * Jean + 22 * George <= 129)

# Solve the model
m.optimize()

# Print results if solution was found, otherwise print a message indicating no feasible solution exists
if m.status == GRB.OPTIMAL:
    print("Solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No feasible solution exists.")
