
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(lb=0, name="H")  # hours worked by Hank
D = m.addVar(lb=0, name="D")  # hours worked by Dale
J = m.addVar(lb=0, name="J")  # hours worked by Jean
G = m.addVar(lb=0, name="G")  # hours worked by George

# Objective function
m.setObjective(6.35*H**2 + 9.71*H*D + 8.11*H*J + 4.03*D*J + 7.08*D*G + 1.55*G**2 + 3.05*H + 5.16*J, gp.GRB.MINIMIZE)

# Constraints
# Individual constraints (not explicitly needed as they are bounds)
# m.addConstr(H >= 0)
# m.addConstr(D >= 0)
# m.addConstr(J >= 0)
# m.addConstr(G >= 0)

# Paperwork competence rating constraints
m.addConstr(H + J >= 41)
m.addConstr(D + J >= 41)
m.addConstr(D + G >= 41)
m.addConstr(H**2 + D**2 >= 29)
m.addConstr(H**2 + D**2 + J**2 >= 26)
m.addConstr(H*J*G >= 26)  # Note: This might not be correctly interpreted from the problem statement
m.addConstr(H + D + J >= 43)
m.addConstr(H*J*G >= 43)  # Note: This might not be correctly interpreted
m.addConstr(H + D + J + G >= 43)

# Organization score constraints
m.addConstr(23*H + 11*D >= 30)
m.addConstr(5*J + 16*G >= 29)
m.addConstr(23**2*H**2 + 5**2*J**2 >= 21)
m.addConstr(23*H + 11*D + 5*J + 16*G >= 21)

# Work quality rating constraints
m.addConstr(22*H + 2*G >= 26)
m.addConstr(22*H + 5*D + 14*J + 2*G >= 26)

# Dollar cost per hour constraints
m.addConstr(13*D + 7*J >= 47)
m.addConstr(19**2*H**2 + 13**2*D**2 >= 19)
m.addConstr(7**2*J**2 + 22**2*G**2 >= 39)
m.addConstr(13*D + 22*G >= 18)
m.addConstr(19*H + 13*D + 7*J + 22*G >= 18)

# Upper bounds
m.addConstr(H**2 + J**2 <= 165)
m.addConstr(D**2 + J**2 + G**2 <= 178)
m.addConstr(23*H + 11*D + 16*G <= 137)
m.addConstr(23**2*H**2 + 5**2*J**2 + 22**2*G**2 <= 88)
m.addConstr(22*H + 2*G <= 121)
m.addConstr(14*J + 2*G <= 144)
m.addConstr(5**2*D**2 + 2**2*G**2 <= 170)
m.addConstr(19**2*H**2 + 13**2*D**2 + 22**2*G**2 <= 90)
m.addConstr(13**2*D**2 + 7**2*J**2 + 22**2*G**2 <= 55)
m.addConstr(19*H + 13*D + 7*J <= 146)
m.addConstr(19*H + 7*J + 22*G <= 129)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("H:", H.varValue)
    print("D:", D.varValue)
    print("J:", J.varValue)
    print("G:", G.varValue)
    print("Objective:", m.objVal)
else:
    print("No optimal solution found")
