
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
vitamin_b4 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b4")
fat = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fat")
vitamin_a = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_a")
vitamin_b9 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b9")
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")

# Set objective function
model.setObjective(5.81 * fiber + 5.03 * vitamin_b4 + 5.98 * fat + 5.46 * vitamin_a + 7.33 * vitamin_b9 + 4.03 * zinc, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * vitamin_b4 + 10 * vitamin_b9 >= 25, "c1")
model.addConstr(9 * fiber + 5 * vitamin_b4 >= 24, "c2")
model.addConstr(10 * vitamin_b9 + 2 * zinc >= 13, "c3")
model.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 35, "c4")
model.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 35, "c5")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 35, "c6")
model.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 35, "c7")
model.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 26, "c8")
model.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 26, "c9")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 26, "c10")
model.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 26, "c11")
model.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 25, "c12")
model.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 25, "c13")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 25, "c14")
model.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 25, "c15")
model.addConstr(5 * vitamin_b4 + 14 * vitamin_a + 2 * zinc >= 30, "c16")
model.addConstr(9 * fiber + 14 * vitamin_a + 2 * zinc >= 30, "c17")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat >= 30, "c18")
model.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 30, "c19")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 8 * fat + 14 * vitamin_a + 10 * vitamin_b9 + 2 * zinc >= 30, "c20")
model.addConstr(-8 * fat + 3 * zinc >= 0, "c21")
model.addConstr(10 * fat - 5 * vitamin_b9 >= 0, "c22")
model.addConstr(7 * vitamin_b4 - 1 * zinc >= 0, "c23")
model.addConstr(-7 * fiber + 5 * zinc >= 0, "c24")
model.addConstr(-9 * fiber + 1 * vitamin_b4 >= 0, "c25")
model.addConstr(-6 * vitamin_b4 - 6 * vitamin_b9 + 6 * zinc >= 0, "c26")
model.addConstr(9 * fiber + 5 * vitamin_b4 + 2 * zinc <= 167, "c27")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

