
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
fiber = m.addVar(name="fiber", lb=0)  # grams of fiber
vitamin_B4 = m.addVar(name="vitamin_B4", lb=0)  # milligrams of vitamin B4
fat = m.addVar(name="fat", lb=0)  # grams of fat
vitamin_A = m.addVar(name="vitamin_A", lb=0)  # milligrams of vitamin A
vitamin_B9 = m.addVar(name="vitamin_B9", lb=0)  # milligrams of vitamin B9
zinc = m.addVar(name="zinc", lb=0)  # milligrams of zinc

# Define the objective function
m.setObjective(5.81 * fiber + 5.03 * vitamin_B4 + 5.98 * fat + 5.46 * vitamin_A + 7.33 * vitamin_B9 + 4.03 * zinc, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * fiber <= 230)
m.addConstr(5 * vitamin_B4 <= 230)
m.addConstr(8 * fat <= 230)
m.addConstr(14 * vitamin_A <= 230)
m.addConstr(10 * vitamin_B9 <= 230)
m.addConstr(2 * zinc <= 230)

m.addConstr(5 * vitamin_B4 + 10 * vitamin_B9 >= 25)
m.addConstr(9 * fiber + 5 * vitamin_B4 >= 24)
m.addConstr(10 * vitamin_B9 + 2 * zinc >= 13)
m.addConstr(5 * vitamin_B4 + 14 * vitamin_A + 2 * zinc >= 35)
m.addConstr(9 * fiber + 14 * vitamin_A + 2 * zinc >= 35)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 8 * fat >= 35)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 35)
m.addConstr(5 * vitamin_B4 + 14 * vitamin_A + 2 * zinc >= 26)
m.addConstr(9 * fiber + 14 * vitamin_A + 2 * zinc >= 26)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 8 * fat >= 26)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 26)
m.addConstr(5 * vitamin_B4 + 14 * vitamin_A + 2 * zinc >= 25)
m.addConstr(9 * fiber + 14 * vitamin_A + 2 * zinc >= 25)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 8 * fat >= 25)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 25)
m.addConstr(5 * vitamin_B4 + 14 * vitamin_A + 2 * zinc >= 30)
m.addConstr(9 * fiber + 14 * vitamin_A + 2 * zinc >= 30)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 8 * fat >= 30)
m.addConstr(9 * fiber + 8 * fat + 2 * zinc >= 30)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 8 * fat + 14 * vitamin_A + 10 * vitamin_B9 + 2 * zinc >= 30)

m.addConstr(-8 * fat + 3 * zinc >= 0)
m.addConstr(10 * fat - 5 * vitamin_B9 >= 0)
m.addConstr(7 * vitamin_B4 - 1 * zinc >= 0)
m.addConstr(-7 * fiber + 5 * zinc >= 0)
m.addConstr(-9 * fiber + 1 * vitamin_B4 >= 0)
m.addConstr(-6 * vitamin_B4 - 6 * vitamin_B9 + 6 * zinc >= 0)
m.addConstr(9 * fiber + 5 * vitamin_B4 + 2 * zinc <= 167)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Grams of fiber:", fiber.varValue)
    print("Milligrams of vitamin B4:", vitamin_B4.varValue)
    print("Grams of fat:", fat.varValue)
    print("Milligrams of vitamin A:", vitamin_A.varValue)
    print("Milligrams of vitamin B9:", vitamin_B9.varValue)
    print("Milligrams of zinc:", zinc.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
