
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="rotisserie_chickens", lb=0)  # No lower bound specified
x1 = m.addVar(name="bananas", lb=0, integrality=gurobi.GRB.INTEGER)  
x2 = m.addVar(name="bowls_of_pasta", lb=0, integrality=gurobi.GRB.INTEGER)  
x3 = m.addVar(name="green_beans", lb=0, integrality=gurobi.GRB.INTEGER)  
x4 = m.addVar(name="ham_sandwiches", lb=0, integrality=gurobi.GRB.INTEGER)  
x5 = m.addVar(name="potatoes", lb=0, integrality=gurobi.GRB.INTEGER)  

# Define the objective function
m.setObjective(8.59 * x0 + 2.22 * x1 + 4.3 * x2 + 9.61 * x3 + 5.47 * x4 + 3.93 * x5, gurobi.GRB.MAXIMIZE)

# Sourness index constraints
m.addConstr(5 * x0 + 5 * x5 >= 24)
m.addConstr(5 * x0 + 7 * x1 + 6 * x4 >= 27)
m.addConstr(12 * x3 + 6 * x4 + 5 * x5 >= 27)
m.addConstr(7 * x1 + 14 * x2 + 5 * x5 >= 27)
m.addConstr(7 * x1 + 14 * x2 + 12 * x3 >= 27)
m.addConstr(14 * x2 + 12 * x3 + 6 * x4 >= 27)
m.addConstr(5 * x0 + 7 * x1 + 14 * x2 >= 27)
m.addConstr(5 * x0 + 12 * x3 + 5 * x5 >= 27)
m.addConstr(5 * x0 + 14 * x2 + 5 * x5 >= 27)
m.addConstr(14 * x2 + 6 * x4 + 5 * x5 >= 27)
m.addConstr(5 * x0 + 7 * x1 + 6 * x4 >= 31)
m.addConstr(12 * x3 + 6 * x4 + 5 * x5 >= 31)
m.addConstr(7 * x1 + 14 * x2 + 5 * x5 >= 31)
m.addConstr(7 * x1 + 14 * x2 + 12 * x3 >= 31)
m.addConstr(14 * x2 + 12 * x3 + 6 * x4 >= 31)
m.addConstr(5 * x0 + 7 * x1 + 14 * x2 >= 31)
m.addConstr(5 * x0 + 12 * x3 + 5 * x5 >= 31)
m.addConstr(5 * x0 + 14 * x2 + 5 * x5 >= 31)
m.addConstr(14 * x2 + 6 * x4 + 5 * x5 >= 31)
m.addConstr(5 * x0 + 7 * x1 + 6 * x4 >= 40)
m.addConstr(12 * x3 + 6 * x4 + 5 * x5 >= 40)
m.addConstr(7 * x1 + 14 * x2 + 5 * x5 >= 40)
m.addConstr(7 * x1 + 14 * x2 + 12 * x3 >= 40)
m.addConstr(14 * x2 + 12 * x3 + 6 * x4 >= 40)
m.addConstr(5 * x0 + 7 * x1 + 14 * x2 >= 40)
m.addConstr(5 * x0 + 12 * x3 + 5 * x5 >= 40)
m.addConstr(5 * x0 + 14 * x2 + 5 * x5 >= 40)
m.addConstr(14 * x2 + 6 * x4 + 5 * x5 >= 40)

# Iron content constraints
m.addConstr(3 * x0 + 7 * x1 + 7 * x2 + 5 * x3 + 4 * x4 + 10 * x5 <= 292)
m.addConstr(3 * x0 + 4 * x4 + 10 * x5 >= 17)
m.addConstr(3 * x0 + 4 * x4 >= 27)
m.addConstr(7 * x1 + 7 * x2 >= 16)
m.addConstr(7 * x2 + 5 * x3 >= 34)
m.addConstr(3 * x0 + 7 * x2 + 5 * x3 >= 28)

# Additional constraints
m.addConstr(7 * x1 + 12 * x3 <= 114)
m.addConstr(14 * x2 + 12 * x3 <= 67)
m.addConstr(12 * x3 + 6 * x4 <= 283)
m.addConstr(5 * x0 + 6 * x4 <= 231)
m.addConstr(5 * x0 + 14 * x2 + 12 * x3 <= 72)
m.addConstr(5 * x0 + 14 * x2 + 5 * x5 <= 109)
m.addConstr(5 * x0 + 7 * x1 + 14 * x2 + 12 * x3 + 6 * x4 + 5 * x5 <= 109)

m.addConstr(3 * x0 + 7 * x1 <= 256)
m.addConstr(7 * x2 + 5 * x3 <= 173)
m.addConstr(7 * x1 + 7 * x2 <= 191)
m.addConstr(7 * x2 + 10 * x5 <= 248)
m.addConstr(3 * x0 + 7 * x1 + 4 * x4 <= 195)
m.addConstr(3 * x0 + 7 * x1 + 7 * x2 <= 70)
m.addConstr(3 * x0 + 5 * x3 + 4 * x4 <= 276)
m.addConstr(7 * x1 + 7 * x2 + 4 * x4 <= 133)
m.addConstr(7 * x1 + 7 * x2 + 10 * x5 <= 95)
m.addConstr(7 * x1 + 4 * x4 + 10 * x5 <= 133)
m.addConstr(3 * x0 + 4 * x4 + 10 * x5 <= 204)
m.addConstr(3 * x0 + 7 * x1 + 10 * x5 <= 212)
m.addConstr(5 * x3 + 4 * x4 + 10 * x5 <= 165)
m.addConstr(7 * x2 + 4 * x4 + 10 * x5 <= 143)
m.addConstr(3 * x0 + 7 * x1 + 7 * x2 + 5 * x3 + 4 * x4 + 10 * x5 <= 143)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Rotisserie chickens: ", x0.varValue)
    print("Bananas: ", x1.varValue)
    print("Bowls of pasta: ", x2.varValue)
    print("Green beans: ", x3.varValue)
    print("Ham sandwiches: ", x4.varValue)
    print("Potatoes: ", x5.varValue)
else:
    print("No solution found")
