
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank = m.addVar(lb=0, name="hank", vtype=gp.GRB.CONTINUOUS)
george = m.addVar(lb=0, name="george", vtype=gp.GRB.CONTINUOUS)
bill = m.addVar(lb=0, name="bill", vtype=gp.GRB.CONTINUOUS)
dale = m.addVar(lb=0, name="dale", vtype=gp.GRB.CONTINUOUS)
paul = m.addVar(lb=0, name="paul", vtype=gp.GRB.CONTINUOUS)

# Set objective function
m.setObjective(7.25*hank**2 + 7.27*hank*dale + 7.69*george*bill + 8.91*george*paul + 7.61*paul**2 + 7.84*hank + 6.05*bill + 6.3*dale, gp.GRB.MINIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': {'hank': 3, 'george': 9, 'bill': 14, 'dale': 1, 'paul': 20},
    'r1': {'hank': 17, 'george': 13, 'bill': 2, 'dale': 3, 'paul': 15},
    'r2': {'hank': 3, 'george': 7, 'bill': 20, 'dale': 7, 'paul': 20}
}

# Resource upper bounds
resource_bounds = {'r0': 160, 'r1': 202, 'r2': 242}


# Add constraints
m.addConstr(9*george**2 + dale**2 >= 32)
m.addConstr(3*hank + 20*paul >= 27)
m.addConstr(14*bill + dale >= 21)
m.addConstr(9*george + 14*bill >= 28)
m.addConstr(3*hank**2 + 14*bill**2 + dale**2 >= 22)
m.addConstr(3*hank**2 + dale**2 + 20*paul**2 >= 22)
m.addConstr(3*hank + 14*bill + 20*paul >= 22)
m.addConstr(9*george + 14*bill + 20*paul >= 22)
m.addConstr(3*hank + 14*bill + dale >= 28)
m.addConstr(3*hank + dale + 20*paul >= 28)
m.addConstr(3*hank + 14*bill + 20*paul >= 28)
m.addConstr(9*george + 14*bill + 20*paul >= 28)
m.addConstr(3*hank**2 + 14*bill**2 + dale**2 >= 32)
m.addConstr(3*hank + dale + 20*paul >= 32)
m.addConstr(3*hank**2 + 14*bill**2 + 20*paul**2 >= 32)
m.addConstr(9*george + 14*bill + 20*paul >= 32)
m.addConstr(3*hank + 14*bill + dale >= 18)
m.addConstr(3*hank + dale + 20*paul >= 18)
m.addConstr(3*hank + 14*bill + 20*paul >= 18)
m.addConstr(9*george**2 + 14*bill**2 + 20*paul**2 >= 18)
m.addConstr(3*hank + 9*george + 14*bill + dale + 20*paul >= 18)
m.addConstr(17*hank + 2*bill >= 24)
m.addConstr(13*george + 3*dale >= 34)
m.addConstr(17*hank**2 + 15*paul**2 >= 24)
m.addConstr(13*george + 3*dale + 15*paul >= 33)
m.addConstr(17*hank + 13*george + 15*paul >= 33)
m.addConstr(17*hank + 3*dale + 15*paul >= 33)
m.addConstr(13*george**2 + 2*bill**2 + 15*paul**2 >= 33)
m.addConstr(17*hank + 13*george + 3*dale >= 33)
m.addConstr(13*george + 3*dale + 15*paul >= 20)
m.addConstr(17*hank + 13*george + 15*paul >= 20)
m.addConstr(17*hank**2 + 3*dale**2 + 15*paul**2 >= 20)
m.addConstr(13*george + 2*bill + 15*paul >= 20)
m.addConstr(17*hank + 13*george + 3*dale >= 20)
m.addConstr(13*george + 3*dale + 15*paul >= 25)
m.addConstr(17*hank**2 + 13*george**2 + 15*paul**2 >= 25)
m.addConstr(17*hank + 3*dale + 15*paul >= 25)
m.addConstr(13*george**2 + 2*bill**2 + 15*paul**2 >= 25)
m.addConstr(17*hank**2 + 13*george**2 + 3*dale**2 >= 25)
m.addConstr(13*george + 3*dale + 15*paul >= 33)
m.addConstr(17*hank**2 + 13*george**2 + 15*paul**2 >= 33)
m.addConstr(17*hank + 3*dale + 15*paul >= 33)
m.addConstr(13*george**2 + 2*bill**2 + 15*paul**2 >= 33)
m.addConstr(17*hank + 13*george + 3*dale >= 33)
m.addConstr(13*george + 3*dale + 15*paul >= 21)
m.addConstr(17*hank**2 + 13*george**2 + 15*paul**2 >= 21)
m.addConstr(17*hank**2 + 3*dale**2 + 15*paul**2 >= 21)
m.addConstr(13*george**2 + 2*bill**2 + 15*paul**2 >= 21)
m.addConstr(17*hank + 13*george + 3*dale >= 21)
m.addConstr(17*hank + 13*george + 2*bill + 3*dale + 15*paul >= 21)
m.addConstr(3*hank + 20*paul >= 18)
m.addConstr(3*hank**2 + 7*george**2 >= 21)
m.addConstr(20*bill**2 + 20*paul**2 >= 27)
m.addConstr(7*dale**2 + 20*paul**2 >= 41)
m.addConstr(3*hank + 7*george + 20*bill + 7*dale + 20*paul >= 41)
m.addConstr(4*hank - 2*george >= 0)
m.addConstr(9*hank - 9*bill >= 0)
m.addConstr(9*george**2 + 14*bill**2 + dale**2 <= 113)
m.addConstr(3*hank + 14*bill + dale <= 66)
m.addConstr(3*hank**2 + 14*bill**2 + 20*paul**2 <= 135)
m.addConstr(9*george**2 + 14*bill**2 + 20*paul**2 <= 65)
m.addConstr(3*hank + 9*george + 14*bill <= 79)
m.addConstr(3*hank + 9*george + dale <= 63)
m.addConstr(9*george**2 + dale**2 + 20*paul**2 <= 98)
m.addConstr(17*hank + 13*george <= 125)
m.addConstr(17*hank + 2*bill <= 179)
m.addConstr(3*hank + 7*dale + 20*paul <= 193)
m.addConstr(3*hank + 7*george + 20*bill <= 136)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
