
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(lb=-gp.inf, name="hours_worked_by_Hank")
G = m.addVar(lb=-gp.inf, name="hours_worked_by_George")
B = m.addVar(lb=-gp.inf, name="hours_worked_by_Bill")
D = m.addVar(lb=-gp.inf, name="hours_worked_by_Dale")
P = m.addVar(lb=-gp.inf, name="hours_worked_by_Paul")

# Objective function
m.setObjective(7.25 * H**2 + 7.27 * H * G + 7.69 * G * B + 8.91 * G * P + 7.61 * P**2 + 7.84 * H + 6.05 * B + 6.3 * D, gp.GRB.MINIMIZE)

# Constraints
# Individual ratings
m.addConstr(H >= 0, name="H_non_negative")
m.addConstr(G >= 0, name="G_non_negative")
m.addConstr(B >= 0, name="B_non_negative")
m.addConstr(D >= 0, name="D_non_negative")
m.addConstr(P >= 0, name="P_non_negative")

# Computer competence rating constraints
m.addConstr(G**2 + D**2 >= 32, name="computer_competence_GD")
m.addConstr(H + P >= 27, name="computer_competence_HP")
m.addConstr(B + D >= 21, name="computer_competence_BD")
m.addConstr(G + B >= 28, name="computer_competence_GB")
m.addConstr(H**2 + B**2 + D**2 >= 22, name="computer_competence_HBD")
m.addConstr(H**2 + D**2 + P**2 >= 22, name="computer_competence_HDP")
m.addConstr(H + B + P >= 22, name="computer_competence_HBP")
m.addConstr(G + B + P >= 22, name="computer_competence_GBP")
m.addConstr(H + B + D >= 28, name="computer_competence_HBD_2")
m.addConstr(H + D + P >= 28, name="computer_competence_HDP_2")
m.addConstr(H**2 + B**2 + D**2 >= 32, name="computer_competence_HBD_3")
m.addConstr(H + D + P >= 32, name="computer_competence_HDP_4")
m.addConstr(H**2 + B**2 + P**2 >= 32, name="computer_competence_HBP_2")
m.addConstr(G + B + P >= 32, name="computer_competence_GBP_2")

# Likelihood to quit index constraints
m.addConstr(H + B >= 24, name="likelihood_to_quit_HB")
m.addConstr(G + D >= 34, name="likelihood_to_quit_GD")
m.addConstr(H**2 + P**2 >= 24, name="likelihood_to_quit_HP")
m.addConstr(G + D + P >= 33, name="likelihood_to_quit_GDP")

# Work quality rating constraints
m.addConstr(H + P >= 18, name="work_quality_HP")
m.addConstr(H**2 + G**2 >= 21, name="work_quality_HG")
m.addConstr(B**2 + P**2 >= 27, name="work_quality_BP")
m.addConstr(D**2 + P**2 >= 41, name="work_quality_DP")
m.addConstr(H + G + B + D + P >= 41, name="work_quality_all")

# Linear constraints
m.addConstr(4 * H - 2 * G >= 0, name="linear_constraint_1")
m.addConstr(9 * H - 9 * B >= 0, name="linear_constraint_2")

# Computer competence rating upper bounds
m.addConstr(G**2 + B**2 + D**2 <= 113, name="computer_competence_upper_GBD")
m.addConstr(H + B + D <= 66, name="computer_competence_upper_HBD")
m.addConstr(H**2 + B**2 + P**2 <= 135, name="computer_competence_upper_HBP")
m.addConstr(G**2 + B**2 + P**2 <= 65, name="computer_competence_upper_GBP")
m.addConstr(H + G + B <= 79, name="computer_competence_upper_HGB")
m.addConstr(H + G + D <= 63, name="computer_competence_upper_HGD")
m.addConstr(G**2 + D**2 + P**2 <= 98, name="computer_competence_upper_GDP")

# Likelihood to quit index upper bounds
m.addConstr(H + G <= 125, name="likelihood_to_quit_upper_HG")
m.addConstr(H + B <= 179, name="likelihood_to_quit_upper_HB")

# Work quality rating upper bounds
m.addConstr(H + D + P <= 193, name="work_quality_upper_HDP")
m.addConstr(H + G + B <= 136, name="work_quality_upper_HGB")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {H.varValue}")
    print(f"Hours worked by George: {G.varValue}")
    print(f"Hours worked by Bill: {B.varValue}")
    print(f"Hours worked by Dale: {D.varValue}")
    print(f"Hours worked by Paul: {P.varValue}")
else:
    print("No optimal solution found.")
