
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="mechanized infantry companies")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="logistics companies")

# Set objective function
m.setObjective(4.6 * x0 + 8.11 * x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * x0 + 6 * x1 >= 17, "mobility_lower_bound")
m.addConstr(1 * x0 + 10 * x1 >= 21, "defense_lower_bound")
m.addConstr(6 * x0 + 9 * x1 >= 20, "logistics_lower_bound")
m.addConstr(2 * x0 + 4 * x1 >= 19, "fun_lower_bound")
m.addConstr(-3 * x0 + 10 * x1 >= 0, "custom_constraint")

m.addConstr(5 * x0 + 6 * x1 <= 64, "mobility_upper_bound")
m.addConstr(1 * x0 + 10 * x1 <= 79, "defense_upper_bound")
m.addConstr(6 * x0 + 9 * x1 <= 36, "logistics_upper_bound")
m.addConstr(2 * x0 + 4 * x1 <= 64, "fun_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('mechanized infantry companies:', x0.x)
    print('logistics companies:', x1.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

