
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")

# Objective function
m.setObjective(4.6*x0 + 8.11*x1, GRB.MINIMIZE)

# Constraints
# Mobility rating constraint
m.addConstr(5*x0 + 6*x1 >= 17, "mobility_rating_min")
m.addConstr(5*x0 + 6*x1 <= 64, "mobility_rating_max")

# Defensive capability rating constraint
m.addConstr(1*x0 + 10*x1 >= 21, "defensive_capability_min")
m.addConstr(1*x0 + 10*x1 <= 79, "defensive_capability_max")

# Logistical capacity constraint
m.addConstr(6*x0 + 9*x1 >= 20, "logistical_capacity_min")
m.addConstr(6*x0 + 9*x1 <= 36, "logistical_capacity_max")

# Fun factor constraint
m.addConstr(2*x0 + 4*x1 >= 19, "fun_factor_min")
m.addConstr(2*x0 + 4*x1 <= 64, "fun_factor_max")

# Additional linear constraint
m.addConstr(-3*x0 + 10*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mechanized Infantry Companies: {x0.x}")
    print(f"Logistics Companies: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
