
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
mechanized_infantry_companies = m.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
logistics_companies = m.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4.6 * mechanized_infantry_companies + 8.11 * logistics_companies, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(5 * mechanized_infantry_companies + 6 * logistics_companies >= 17, name="mobility_rating_min")
m.addConstr(5 * mechanized_infantry_companies + 6 * logistics_companies <= 64, name="mobility_rating_max")
m.addConstr(1 * mechanized_infantry_companies + 10 * logistics_companies >= 21, name="defensive_capability_rating_min")
m.addConstr(1 * mechanized_infantry_companies + 10 * logistics_companies <= 79, name="defensive_capability_rating_max")
m.addConstr(6 * mechanized_infantry_companies + 9 * logistics_companies >= 20, name="logistical_capacity_min")
m.addConstr(6 * mechanized_infantry_companies + 9 * logistics_companies <= 36, name="logistical_capacity_max")
m.addConstr(2 * mechanized_infantry_companies + 4 * logistics_companies >= 19, name="fun_factor_min")
m.addConstr(2 * mechanized_infantry_companies + 4 * logistics_companies <= 64, name="fun_factor_max")
m.addConstr(-3 * mechanized_infantry_companies + 10 * logistics_companies >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Mechanized infantry companies: {mechanized_infantry_companies.varValue}")
    print(f"Logistics companies: {logistics_companies.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
