
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_Paul = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
hours_worked_by_Hank = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function: Maximize 6 * hours_worked_by_Paul + 4 * hours_worked_by_Hank
m.setObjective(6 * hours_worked_by_Paul + 4 * hours_worked_by_Hank, GRB.MAXIMIZE)

# Constraints
m.addConstr(13 * hours_worked_by_Paul + 3 * hours_worked_by_Hank >= 8, name="organization_score_min")
m.addConstr(6 * hours_worked_by_Paul + 14 * hours_worked_by_Hank >= 29, name="likelihood_to_quit_index_min")
m.addConstr(6 * hours_worked_by_Paul + 13 * hours_worked_by_Hank >= 7, name="dollar_cost_per_hour_min")
m.addConstr(11 * hours_worked_by_Paul + 11 * hours_worked_by_Hank >= 17, name="paperwork_competence_rating_min")
m.addConstr(4 * hours_worked_by_Paul - 7 * hours_worked_by_Hank >= 0, name="specific_constraint")

m.addConstr(13 * hours_worked_by_Paul + 3 * hours_worked_by_Hank <= 42, name="organization_score_max")
m.addConstr(6 * hours_worked_by_Paul + 14 * hours_worked_by_Hank <= 42, name="likelihood_to_quit_index_max")
m.addConstr(6 * hours_worked_by_Paul + 13 * hours_worked_by_Hank <= 38, name="dollar_cost_per_hour_max")
m.addConstr(11 * hours_worked_by_Paul + 11 * hours_worked_by_Hank <= 20, name="paperwork_competence_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.x}")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
