
from gurobipy import Model, GRB

# Create a new model
m = Model("plant_optimization")

# Create variables
boxwoods = m.addVar(vtype=GRB.INTEGER, name="boxwoods")
lilies = m.addVar(vtype=GRB.INTEGER, name="lilies")

# Set objective function
m.setObjective(9.81 * boxwoods + 3.17 * lilies, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * boxwoods + 1 * lilies >= 31, "min_cost")  # Minimum cost
m.addConstr(7 * boxwoods + 7 * lilies >= 9, "min_water")  # Minimum water need
m.addConstr(7 * boxwoods - 2 * lilies >= 0, "boxwood_lily_ratio")  # Boxwood to lily ratio
m.addConstr(5 * boxwoods + 1 * lilies <= 46, "max_cost")  # Maximum cost
m.addConstr(7 * boxwoods + 7 * lilies <= 35, "max_water")  # Maximum water need


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Boxwoods: {boxwoods.x}")
    print(f"  Lilies: {lilies.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

