
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
boxwoods = m.addVar(vtype=GRB.INTEGER, name="boxwoods")
lilies = m.addVar(vtype=GRB.INTEGER, name="lilies")

# Objective function
m.setObjective(9.81 * boxwoods + 3.17 * lilies, GRB.MINIMIZE)

# Constraints
m.addConstr(5 * boxwoods + 1 * lilies >= 31, "Minimum_Spend")
m.addConstr(7 * boxwoods + 7 * lilies >= 9, "Minimum_Water_Need")
m.addConstr(7 * boxwoods - 2 * lilies >= 0, "Specific_Linear_Constraint")
m.addConstr(5 * boxwoods + 1 * lilies <= 46, "Maximum_Spend")
m.addConstr(7 * boxwoods + 7 * lilies <= 35, "Maximum_Water_Need")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Boxwoods: {boxwoods.x}")
    print(f"Lilies: {lilies.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
