
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
boxwoods = m.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
lilies = m.addVar(name="lilies", vtype=gurobi.GRB.INTEGER)

# Objective function: minimize 9.81 * boxwoods + 3.17 * lilies
m.setObjective(9.81 * boxwoods + 3.17 * lilies, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * boxwoods + lilies >= 31, name="min_cost")
m.addConstr(5 * boxwoods + lilies <= 65, name="max_cost")
m.addConstr(7 * boxwoods + 7 * lilies >= 9, name="min_water")
m.addConstr(7 * boxwoods + 7 * lilies <= 38, name="max_water")
m.addConstr(7 * boxwoods - 2 * lilies >= 0, name="boxwoods_vs_lilies")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Boxwoods: {boxwoods.varValue}")
    print(f"Lilies: {lilies.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
