
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="protein_bars")
instant_ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="instant_ramen")

# Set objective function
m.setObjective(1.21 * apple_pies**2 + 2.36 * apple_pies * protein_bars + 7.88 * apple_pies + 2.72 * instant_ramen, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(19 * protein_bars + 19 * instant_ramen >= 86, "c1")
m.addConstr(apple_pies**2 + protein_bars**2 + instant_ramen**2 >= 45, "c2")
m.addConstr(18 * protein_bars + 14 * instant_ramen >= 99, "c3")
m.addConstr(10 * apple_pies**2 + 14 * instant_ramen**2 >= 97, "c4")
m.addConstr(10 * apple_pies**2 + 18 * protein_bars**2 >= 114, "c5")
m.addConstr(apple_pies**2 + protein_bars**2 <= 200, "c6")
m.addConstr(apple_pies**2 + instant_ramen**2 <= 168, "c7")
m.addConstr(19 * protein_bars + 19 * instant_ramen <= 188, "c8")
m.addConstr(apple_pies + protein_bars + instant_ramen <= 188, "c9") # This constraint seems redundant given c8 and positive coefficients
m.addConstr(18 * protein_bars**2 + 14 * instant_ramen**2 <= 291, "c10")
m.addConstr(10 * apple_pies**2 + 18 * protein_bars**2 <= 277, "c11")
m.addConstr(10 * apple_pies + 18 * protein_bars + 14 * instant_ramen <= 277, "c12")
m.addConstr(apple_pies <= 275, "r0") # Umami constraint for apple pies
m.addConstr(10 * apple_pies <= 391, "r1") # Fat constraint for apple pies


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('apple_pies:', apple_pies.x)
    print('protein_bars:', protein_bars.x)
    print('instant_ramen:', instant_ramen.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

