
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
apple_pies = model.addVar(name="apple_pies", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
protein_bars = model.addVar(name="protein_bars", lb=0, ub=gurobi.GRB.INFINITY, integrality=gurobi.GRB.INTEGER)
bowls_of_instant_ramen = model.addVar(name="bowls_of_instant_ramen", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(1.21 * apple_pies**2 + 2.36 * apple_pies * protein_bars + 7.88 * apple_pies + 2.72 * bowls_of_instant_ramen, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(19 * protein_bars + 19 * bowls_of_instant_ramen >= 86)
model.addConstr(apple_pies**2 + protein_bars**2 + bowls_of_instant_ramen**2 >= 45)
model.addConstr(18 * protein_bars + 14 * bowls_of_instant_ramen >= 99)
model.addConstr(100 * apple_pies**2 + 196 * bowls_of_instant_ramen**2 >= 97)
model.addConstr(100 * apple_pies**2 + 324 * protein_bars**2 >= 114)
model.addConstr(apple_pies**2 + protein_bars**2 <= 200)
model.addConstr(apple_pies**2 + bowls_of_instant_ramen**2 <= 168)
model.addConstr(19 * protein_bars + 19 * bowls_of_instant_ramen <= 188)
model.addConstr(apple_pies + 19 * protein_bars + 19 * bowls_of_instant_ramen <= 188)
model.addConstr(324 * protein_bars**2 + 196 * bowls_of_instant_ramen**2 <= 291)
model.addConstr(100 * apple_pies**2 + 324 * protein_bars**2 <= 277)
model.addConstr(10 * apple_pies + 18 * protein_bars + 14 * bowls_of_instant_ramen <= 277)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Apple pies: ", apple_pies.varValue)
    print("Protein bars: ", protein_bars.varValue)
    print("Bowls of instant ramen: ", bowls_of_instant_ramen.varValue)
else:
    print("The model is infeasible")
