
from gurobipy import Model, GRB

# Create a new model
model = Model("resource_allocation")

# Create variables
corn_cobs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
cherry_pies = model.addVar(lb=0, vtype=GRB.INTEGER, name="cherry_pies")

# Set objective function
model.setObjective(7.91 * corn_cobs + 4.62 * cherry_pies, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * corn_cobs + 16 * cherry_pies >= 56, "fat_min")
model.addConstr(15 * corn_cobs + 16 * cherry_pies >= 39, "sourness_min")
model.addConstr(16 * corn_cobs + 15 * cherry_pies >= 25, "calcium_min")
model.addConstr(-3 * corn_cobs + 9 * cherry_pies >= 0, "custom_constraint")

model.addConstr(20 * corn_cobs + 16 * cherry_pies <= 101, "fat_max") # Combined max fat constraint
model.addConstr(15 * corn_cobs + 16 * cherry_pies <= 47, "sourness_max") # Combined max sourness constraint
model.addConstr(16 * corn_cobs + 15 * cherry_pies <= 97, "calcium_max") # Combined max calcium constraint


# Resource constraints (from the context information) - these are redundant given the other constraints
# model.addConstr(20 * corn_cobs + 16 * cherry_pies <= 124, "fat_resource_limit")
# model.addConstr(15 * corn_cobs + 16 * cherry_pies <= 79, "sourness_resource_limit")
# model.addConstr(16 * corn_cobs + 15 * cherry_pies <= 133, "calcium_resource_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Corn cobs: {corn_cobs.x}")
    print(f"Cherry pies: {cherry_pies.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

