
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="corn_cobs")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="cherry_pies")

# Define the objective function
m.setObjective(7.91*x0 + 4.62*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x0 + 16*x1 >= 56, "min_fat")
m.addConstr(20*x0 + 16*x1 <= 101, "max_fat")
m.addConstr(15*x0 + 16*x1 >= 39, "min_sourness")
m.addConstr(15*x0 + 16*x1 <= 47, "max_sourness")
m.addConstr(16*x0 + 15*x1 >= 25, "min_calcium")
m.addConstr(16*x0 + 15*x1 <= 97, "max_calcium")
m.addConstr(-3*x0 + 9*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Corn cobs: {x0.x}")
    print(f"Cherry pies: {int(x1.x)}")
else:
    print("No optimal solution found.")
