
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    corn_cobs = model.addVar(name="corn_cobs", lb=0)  # Non-integer
    cherry_pies = model.addVar(name="cherry_pies", lb=0, integrality=gurobi.GRB.INTEGER)  # Integer

    # Objective function
    model.setObjective(7.91 * corn_cobs + 4.62 * cherry_pies, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * corn_cobs + 16 * cherry_pies >= 56, name="fat_min")
    model.addConstr(20 * corn_cobs + 16 * cherry_pies <= 101, name="fat_max")

    model.addConstr(15 * corn_cobs + 16 * cherry_pies >= 39, name="sourness_min")
    model.addConstr(15 * corn_cobs + 16 * cherry_pies <= 47, name="sourness_max")

    model.addConstr(16 * corn_cobs + 15 * cherry_pies >= 25, name="calcium_min")
    model.addConstr(16 * corn_cobs + 15 * cherry_pies <= 97, name="calcium_max")

    model.addConstr(-3 * corn_cobs + 9 * cherry_pies >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Corn Cobs: {corn_cobs.varValue}")
        print(f"Cherry Pies: {cherry_pies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
