
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
green_beans = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_beans")
ham_sandwiches = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham_sandwiches")
cornichons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")

# Set objective function
model.setObjective(1.24 * green_beans + 3.93 * ham_sandwiches + 1.9 * cornichons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons <= 143, "dollar_cost") # Resource constraint r0
model.addConstr(10 * green_beans + 16 * ham_sandwiches + 1 * cornichons <= 131, "fiber_grams") # Resource constraint r1

model.addConstr(6 * green_beans + 15 * ham_sandwiches >= 42, "min_green_beans_ham_sandwiches_cost")
model.addConstr(15 * ham_sandwiches + 4 * cornichons >= 33, "min_ham_sandwiches_cornichons_cost")
model.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons >= 34, "min_total_cost")

model.addConstr(6 * green_beans + 15 * ham_sandwiches <= 72, "max_green_beans_ham_sandwiches_cost")
model.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons <= 72, "max_total_cost")

model.addConstr(16 * ham_sandwiches + 1 * cornichons <= 122, "max_ham_sandwiches_cornichons_fiber")
model.addConstr(10 * green_beans + 16 * ham_sandwiches <= 70, "max_green_beans_ham_sandwiches_fiber")
model.addConstr(10 * green_beans + 16 * ham_sandwiches + 1 * cornichons <= 70, "max_total_fiber")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('green_beans:', green_beans.x)
    print('ham_sandwiches:', ham_sandwiches.x)
    print('cornichons:', cornichons.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

