
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(name="green_beans", lb=0, ub=GRB.INFINITY)
x1 = m.addVar(name="ham_sandwiches", lb=0, ub=GRB.INFINITY)
x2 = m.addVar(name="cornichons", lb=0, ub=GRB.INFINITY)

# Set the objective function
m.setObjective(1.24*x0 + 3.93*x1 + 1.9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 15*x1 <= 143, name="dollar_cost_1")
m.addConstr(10*x0 + 16*x1 + x2 <= 131, name="fiber_total")
m.addConstr(6*x0 + 15*x1 >= 42, name="min_spend_green_ham")
m.addConstr(15*x1 + 4*x2 >= 33, name="min_spend_ham_corn")
m.addConstr(6*x0 + 15*x1 + 4*x2 >= 34, name="min_spend_all")
m.addConstr(6*x0 + 15*x1 <= 72, name="max_spend_green_ham")
m.addConstr(6*x0 + 15*x1 + 4*x2 <= 72, name="max_spend_all")
m.addConstr(16*x1 + x2 <= 122, name="fiber_ham_corn")
m.addConstr(10*x0 + 16*x1 <= 70, name="fiber_green_ham")
m.addConstr(10*x0 + 16*x1 + x2 <= 70, name="fiber_all")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("green_beans:", x0.x)
    print("ham_sandwiches:", x1.x)
    print("cornichons:", x2.x)
else:
    print("No optimal solution found.")
