
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    green_beans = model.addVar(name="green_beans", lb=0)
    ham_sandwiches = model.addVar(name="ham_sandwiches", lb=0)
    cornichons = model.addVar(name="cornichons", lb=0)

    # Objective function
    model.setObjective(1.24 * green_beans + 3.93 * ham_sandwiches + 1.9 * cornichons, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Cost constraints
    model.addConstr(6 * green_beans + 15 * ham_sandwiches >= 42, name="min_spend_green_beans_ham")
    model.addConstr(15 * ham_sandwiches + 4 * cornichons >= 33, name="min_spend_ham_cornichons")
    model.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons >= 34, name="min_total_spend")
    model.addConstr(6 * green_beans + 15 * ham_sandwiches <= 72, name="max_spend_green_beans_ham")
    model.addConstr(6 * green_beans + 15 * ham_sandwiches + 4 * cornichons <= 72, name="max_total_spend")

    # Fiber constraints
    model.addConstr(16 * ham_sandwiches + cornichons <= 122, name="max_fiber_ham_cornichons")
    model.addConstr(10 * green_beans + 16 * ham_sandwiches <= 70, name="max_fiber_green_beans_ham")
    model.addConstr(10 * green_beans + 16 * ham_sandwiches + cornichons <= 70, name="max_total_fiber")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Green Beans: {green_beans.varValue}")
        print(f"Ham Sandwiches: {ham_sandwiches.varValue}")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The problem is infeasible")

optimize_problem()
