
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B12")

# Set objective function
m.setObjective(9.48 * x1 + 7.02 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * x1 + 6 * x2 >= 38, "c1")  # Combined cardiovascular support index >= 38
m.addConstr(-3 * x1 + 5 * x2 >= 0, "c2")  # -3x1 + 5x2 >= 0
m.addConstr(5 * x1 + 6 * x2 <= 82, "c3")  # Combined cardiovascular support index <= 82 (repeated constraint)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Milligrams of vitamin B1: {x1.x}")
    print(f"Milligrams of vitamin B12: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

